/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.utils;

import com.portingdeadmods.nautec.utils.ranges.FloatRange;
import com.portingdeadmods.nautec.utils.ranges.IntRange;

public final class RNGUtils {
    public static float random() {
        return (float)Math.random();
    }

    public static int uniformRandInt(IntRange range) {
        return RNGUtils.uniformRandInt((Integer)range.getMin(), (Integer)range.getMax());
    }

    public static int uniformRandInt(int min, int max) {
        return (int)(Math.random() * (double)(max - min + 1) + (double)min);
    }

    public static int uniformRandLong(long min, long max) {
        return (int)(Math.random() * (double)(max - min + 1L) + (double)min);
    }

    public static int uniformRandInt(int max) {
        return RNGUtils.uniformRandInt(0, max);
    }

    public static float uniformRandFloat(FloatRange range) {
        return RNGUtils.uniformRandFloat(((Float)range.getMin()).floatValue(), ((Float)range.getMax()).floatValue());
    }

    public static float uniformRandFloat(float min, float max) {
        return (float)Math.random() * (max - min) + min;
    }

    public static float uniformRandFloat(float max) {
        return RNGUtils.uniformRandFloat(0.0f, max);
    }

    public static int intInRangeOf(int val, int range) {
        return (int)((float)RNGUtils.uniformRandInt(-val, val) * RNGUtils.random() + (float)range);
    }

    public static int intInRangeOf(int range) {
        return RNGUtils.intInRangeOf(0, range);
    }

    public static float floatInRangeOf(float val, float range) {
        return RNGUtils.uniformRandFloat(-val, val) * RNGUtils.random() + range;
    }

    public static float floatInRangeOf(float range) {
        return RNGUtils.floatInRangeOf(0.0f, range);
    }

    public static float biasedInRangeOf(float val, float range, float bias) {
        float absBias = Math.abs(bias);
        if (bias < 0.0f) {
            return RNGUtils.uniformRandFloat(-range, range * (1.0f - absBias)) + val;
        }
        if (bias > 0.0f) {
            return RNGUtils.uniformRandFloat(-range * (1.0f - absBias), range) + val;
        }
        return RNGUtils.uniformRandFloat(-range, range) + val;
    }

    public static float biasedInRangeOf(float range, float bias) {
        return RNGUtils.biasedInRangeOf(0.0f, range, bias);
    }

    public static float biasedInRange(float rangeStart, float rangeEnd, float bias) {
        float absBias = Math.abs(bias);
        float middlePoint = (rangeStart + rangeEnd) / 2.0f;
        float left = middlePoint - rangeStart;
        float right = rangeEnd - middlePoint;
        if (bias < 0.0f) {
            return RNGUtils.uniformRandFloat(left, right * (1.0f - absBias)) + middlePoint;
        }
        if (bias > 0.0f) {
            return RNGUtils.uniformRandFloat(left * (1.0f - absBias), right) + middlePoint;
        }
        return RNGUtils.uniformRandFloat(left, right) + middlePoint;
    }
}

