/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.registries;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;

public final class NTLootTables {
    private static final Set<ResourceKey<LootTable>> LOCATIONS = new HashSet<ResourceKey<LootTable>>();
    private static final Set<ResourceKey<LootTable>> IMMUTABLE_LOCATIONS = Collections.unmodifiableSet(LOCATIONS);
    public static final ResourceKey<LootTable> CRATE = NTLootTables.register("chests/crate");
    public static final ResourceKey<LootTable> RUSTY_CRATE = NTLootTables.register("chests/rusty_crate");
    public static final ResourceKey<LootTable> BURIED_TREASURE = NTLootTables.register("chests/buried_treasure");
    public static final ResourceKey<LootTable> GUARDIAN = NTLootTables.register("entities/guardian");
    public static final ResourceKey<LootTable> ELDER_GUARDIAN = NTLootTables.register("entities/elder_guardian");
    public static final ResourceKey<LootTable> DROWNED = NTLootTables.register("entities/drowned");
    public static final ResourceKey<LootTable> DOLPHIN = NTLootTables.register("entities/dolphin");

    private static ResourceKey<LootTable> register(String name) {
        return NTLootTables.register((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)name)));
    }

    private static ResourceKey<LootTable> registerV(String name) {
        return NTLootTables.register((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)name)));
    }

    private static ResourceKey<LootTable> register(ResourceKey<LootTable> name) {
        if (LOCATIONS.add(name)) {
            return name;
        }
        throw new IllegalArgumentException(String.valueOf(name.location()) + " is already a registered built-in loot table");
    }
}

