/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.registries;

import com.portingdeadmods.nautec.NTRegistries;
import com.portingdeadmods.nautec.Nautec;
import com.portingdeadmods.nautec.api.bacteria.Bacteria;
import com.portingdeadmods.nautec.api.bacteria.BacteriaInstance;
import com.portingdeadmods.nautec.api.bacteria.CollapsedBacteriaStats;
import com.portingdeadmods.nautec.api.fluids.NTFluid;
import com.portingdeadmods.nautec.api.items.IBacteriaItem;
import com.portingdeadmods.nautec.api.items.IPowerItem;
import com.portingdeadmods.nautec.capabilities.NTCapabilities;
import com.portingdeadmods.nautec.capabilities.power.IPowerStorage;
import com.portingdeadmods.nautec.compat.modonomicon.ModonomiconCompat;
import com.portingdeadmods.nautec.data.NTDataComponents;
import com.portingdeadmods.nautec.data.components.ComponentBacteriaStorage;
import com.portingdeadmods.nautec.registries.NTBacterias;
import com.portingdeadmods.nautec.registries.NTBlocks;
import com.portingdeadmods.nautec.registries.NTFluids;
import com.portingdeadmods.nautec.registries.NTItems;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class NTCreativeTabs {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"nautec");
    public static final Supplier<CreativeModeTab> MAIN = CREATIVE_MODE_TABS.register("main", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"nautec.creative_tab.main")).icon(() -> NTBlocks.AQUATIC_CATALYST.toStack()).displayItems((params, output) -> {
        for (ItemLike item : NTItems.CREATIVE_TAB_ITEMS) {
            if (NTItems.BACTERIA_ITEMS.contains(item)) continue;
            output.accept(item);
            if (!(item.asItem() instanceof IPowerItem)) continue;
            NTCreativeTabs.addPowered(output, item.asItem());
        }
        if (ModList.get().isLoaded("modonomicon")) {
            output.accept(ModonomiconCompat.getItemStack());
        }
        output.accept(NTBlocks.CREATIVE_POWER_SOURCE);
        for (NTFluid fluid : NTFluids.HELPER.getFluids()) {
            DeferredItem<BucketItem> deferredBucket = fluid.getDeferredBucket();
            Nautec.LOGGER.debug("Bucket: {}", deferredBucket);
            output.accept(deferredBucket);
        }
    }).build());
    public static final Supplier<CreativeModeTab> BACTERIA = CREATIVE_MODE_TABS.register("bacteria", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"nautec.creative_tab.bacteria")).icon(() -> NTBlocks.BACTERIAL_ANALYZER.toStack()).displayItems((params, output) -> {
        for (ItemLike item : NTItems.BACTERIA_ITEMS) {
            Optional lookup;
            output.accept(item);
            if (item.asItem() instanceof IPowerItem) {
                NTCreativeTabs.addPowered(output, item.asItem());
            }
            if (!(item.asItem() instanceof IBacteriaItem) || !(lookup = params.holders().lookup(NTRegistries.BACTERIA_KEY)).isPresent()) continue;
            Stream resourceKeyStream = ((HolderLookup.RegistryLookup)lookup.get()).listElementIds();
            resourceKeyStream.forEach(elem -> {
                NTCreativeTabs.addPetriDish(output, params.holders(), item, (ResourceKey<Bacteria>)elem, false);
                NTCreativeTabs.addPetriDish(output, params.holders(), item, (ResourceKey<Bacteria>)elem, true);
            });
        }
    }).build());

    private static void addPetriDish(CreativeModeTab.Output output, HolderLookup.Provider lookup, ItemLike item, ResourceKey<Bacteria> elem, boolean analyzed) {
        if (elem != NTBacterias.EMPTY) {
            ItemStack stack = new ItemStack(item);
            Holder bacteria = lookup.holderOrThrow(elem);
            BacteriaInstance bacteriaInstance = new BacteriaInstance((ResourceKey<Bacteria>)bacteria.getKey(), ((Bacteria)bacteria.value()).maxInitialSize(), (CollapsedBacteriaStats)((Bacteria)bacteria.value()).stats().collapseMaxStats(), analyzed);
            stack.set(NTDataComponents.BACTERIA, (Object)new ComponentBacteriaStorage(bacteriaInstance));
            output.accept(stack);
        }
    }

    public static void addPowered(CreativeModeTab.Output output, Item item) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        IPowerStorage storage = (IPowerStorage)itemStack.getCapability(NTCapabilities.PowerStorage.ITEM);
        if (storage != null) {
            storage.setPowerStored(storage.getPowerCapacity());
            output.accept(itemStack);
        }
    }
}

