/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.events;

import com.mojang.blaze3d.shaders.FogShape;
import com.portingdeadmods.nautec.client.screen.AugmentationViewerScreen;
import com.portingdeadmods.nautec.registries.NTItems;
import com.portingdeadmods.nautec.registries.NTKeybinds;
import com.portingdeadmods.nautec.utils.AugmentHelper;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;

public final class NTClientEvents {

    @EventBusSubscriber(modid="nautec", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
    public static final class ClientInGameBus {
        @SubscribeEvent
        public static void onRenderFog(ViewportEvent.RenderFog event) {
            Entity cameraEntity = Minecraft.getInstance().cameraEntity;
            if (cameraEntity instanceof Player) {
                Player player = (Player)cameraEntity;
                if (cameraEntity.isUnderWater() && player.getItemBySlot(EquipmentSlot.HEAD).is((Item)NTItems.DIVING_HELMET.get())) {
                    event.setNearPlaneDistance(-8.0f);
                    event.setFarPlaneDistance(250.0f);
                    event.setFogShape(FogShape.CYLINDER);
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post event) {
            Minecraft mc = Minecraft.getInstance();
            if (((KeyMapping)NTKeybinds.AUGMENT_SCREEN_KEYBIND.get()).consumeClick() && (Minecraft.getInstance().screen == null || mc.player != null) && !AugmentHelper.getAugments((Player)mc.player).isEmpty()) {
                Minecraft.getInstance().setScreen((Screen)new AugmentationViewerScreen((Component)Component.literal((String)"test"), (Player)Minecraft.getInstance().player));
            }
        }
    }
}

