/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.datagen.recipeBuilder;

import com.portingdeadmods.nautec.api.bacteria.Bacteria;
import com.portingdeadmods.nautec.content.recipes.BacteriaMutationRecipe;
import com.portingdeadmods.nautec.datagen.recipeBuilder.NTRecipeBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

public record MutationRecipeBuilder(ResourceKey<Bacteria> inputBacteria, ResourceKey<Bacteria> resultBacteria, Ingredient catalyst, float chance) implements NTRecipeBuilder
{
    public RecipeBuilder unlockedBy(String s, Criterion<?> criterion) {
        return this;
    }

    public RecipeBuilder group(@Nullable String s) {
        return this;
    }

    public Item getResult() {
        return Items.AIR;
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation resourceLocation) {
        BacteriaMutationRecipe recipe = new BacteriaMutationRecipe(this.inputBacteria, this.resultBacteria, this.catalyst, this.chance);
        recipeOutput.accept(resourceLocation, (Recipe)recipe, null);
    }

    @Override
    public void save(RecipeOutput recipeOutput) {
        StringBuilder builder = new StringBuilder();
        StringBuilder valuesStr = new StringBuilder();
        Ingredient.Value[] values = this.catalyst.getValues();
        ArrayList stacks = new ArrayList();
        for (Ingredient.Value value : values) {
            stacks.addAll(value.getItems());
        }
        stacks.forEach(stack -> {
            ResourceLocation itemLocation = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            valuesStr.append("_").append(itemLocation.getPath().replace(':', '-'));
        });
        builder.append(this.inputBacteria.location().toString().replace(':', '-') + "_" + this.resultBacteria.location().toString().replace(':', '-')).append(valuesStr.toString());
        this.save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)(this.getName() + "/" + String.valueOf(builder))));
    }

    @Override
    public List<Ingredient> getIngredients() {
        return Collections.singletonList(this.catalyst);
    }

    @Override
    public String getName() {
        return "bacteria_mutation";
    }
}

