/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.datagen.loot;

import com.portingdeadmods.nautec.content.multiblocks.AugmentationStationMultiblock;
import com.portingdeadmods.nautec.content.multiblocks.BioReactorMultiblock;
import com.portingdeadmods.nautec.registries.NTBlocks;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class BlockLootTableProvider
extends BlockLootSubProvider {
    private final Set<Block> knownBlocks = new ReferenceOpenHashSet();

    public BlockLootTableProvider(HolderLookup.Provider pRegistries) {
        super(Collections.emptySet(), FeatureFlags.VANILLA_SET, pRegistries);
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }

    protected void add(@NotNull Block block, @NotNull LootTable.Builder table) {
        super.add(block, table);
        this.knownBlocks.add(block);
    }

    protected void generate() {
        this.prismarineSand((Block)NTBlocks.PRISMARINE_SAND.get());
        this.dropSelf((Block)NTBlocks.AQUATIC_CATALYST.get());
        this.dropSelf((Block)NTBlocks.PRISMARINE_RELAY.get());
        this.dropSelf((Block)NTBlocks.LASER_JUNCTION.get());
        this.dropSelf((Block)NTBlocks.LONG_DISTANCE_LASER.get());
        this.dropSelf((Block)NTBlocks.AQUARINE_STEEL_BLOCK.get());
        this.dropSelf((Block)NTBlocks.DARK_PRISMARINE_PILLAR.get());
        this.dropSelf((Block)NTBlocks.CHISELED_DARK_PRISMARINE.get());
        this.dropSelf((Block)NTBlocks.POLISHED_PRISMARINE.get());
        this.dropSelf((Block)NTBlocks.MIXER.get());
        this.dropSelf((Block)NTBlocks.CHARGER.get());
        this.dropSelf((Block)NTBlocks.AUGMENTATION_STATION_EXTENSION.get());
        this.dropSelf((Block)NTBlocks.AUGMENTATION_STATION.get());
        this.dropSelf((Block)NTBlocks.DRAIN.get());
        this.dropSelf((Block)NTBlocks.DRAIN_WALL.get());
        this.add((Block)NTBlocks.AUGMENTATION_STATION_PART.get(), this.multiblockPartDrop((Block)NTBlocks.AUGMENTATION_STATION_PART.get(), AugmentationStationMultiblock.AS_PART, Map.of(0, (Block)NTBlocks.AQUARINE_STEEL_BLOCK.get(), 1, (Block)NTBlocks.POLISHED_PRISMARINE.get(), 2, (Block)NTBlocks.AQUARINE_STEEL_BLOCK.get(), 3, (Block)NTBlocks.POLISHED_PRISMARINE.get(), 4, (Block)NTBlocks.AQUARINE_STEEL_BLOCK.get(), 5, (Block)NTBlocks.POLISHED_PRISMARINE.get(), 6, (Block)NTBlocks.AQUARINE_STEEL_BLOCK.get(), 7, (Block)NTBlocks.POLISHED_PRISMARINE.get(), 8, (Block)NTBlocks.AQUARINE_STEEL_BLOCK.get())));
        this.drainPartDrop((Block)NTBlocks.DRAIN_PART.get());
        this.dropSelf((Block)NTBlocks.BACTERIAL_CONTAINMENT_SHIELD.get());
        this.dropSelf((Block)NTBlocks.INCUBATOR.get());
        this.dropSelf((Block)NTBlocks.MUTATOR.get());
        this.dropSelf((Block)NTBlocks.BIO_REACTOR.get());
        this.add((Block)NTBlocks.BIO_REACTOR_PART.get(), this.createStateDrop((Block)NTBlocks.BIO_REACTOR_PART.get(), BioReactorMultiblock.BIO_REACTOR_PART, Map.of(0, (Block)NTBlocks.DARK_PRISMARINE_PILLAR.get(), 1, (Block)NTBlocks.BACTERIAL_CONTAINMENT_SHIELD.get(), 2, (Block)NTBlocks.DARK_PRISMARINE_PILLAR.get(), 3, (Block)NTBlocks.BACTERIAL_CONTAINMENT_SHIELD.get(), 4, (Block)NTBlocks.POLISHED_PRISMARINE.get(), 5, (Block)NTBlocks.BACTERIAL_CONTAINMENT_SHIELD.get(), 6, (Block)NTBlocks.DARK_PRISMARINE_PILLAR.get(), 7, (Block)NTBlocks.BACTERIAL_CONTAINMENT_SHIELD.get(), 8, (Block)NTBlocks.DARK_PRISMARINE_PILLAR.get())));
        this.dropSelf((Block)NTBlocks.BACTERIAL_ANALYZER.get());
        this.dropSelf((Block)NTBlocks.FISHING_STATION.get());
    }

    protected LootTable.Builder createStateDrop(Block block, IntegerProperty property, Map<Integer, Block> drops) {
        LootPool.Builder builder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
        for (Map.Entry<Integer, Block> entry : drops.entrySet()) {
            builder.add(LootItem.lootTableItem((ItemLike)((ItemLike)entry.getValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)property, entry.getKey().intValue()))));
        }
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)builder));
    }

    protected <T extends Comparable<T> & StringRepresentable> LootTable.Builder createStateDrop(Block block, Property<T> property, Map<T, Block> drops) {
        LootPool.Builder builder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
        for (Map.Entry<T, Block> entry : drops.entrySet()) {
            builder.add(LootItem.lootTableItem((ItemLike)((ItemLike)entry.getValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(property, (Comparable)entry.getKey()))));
        }
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)builder));
    }

    protected void prismarineSand(Block prismarineSandOre) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        this.add(prismarineSandOre, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)prismarineSandOre)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)new ConstantValue(1.0f))).when(this.hasSilkTouch())).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PRISMARINE_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))).when(this.doesNotHaveSilkTouch())).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PRISMARINE_CRYSTALS).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))).when(this.doesNotHaveSilkTouch())));
    }

    protected LootTable.Builder multiblockPartDrop(Block block, IntegerProperty partIndex, Map<Integer, Block> index2blocks) {
        LootPool.Builder builder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
        Integer last = (Integer)partIndex.getPossibleValues().stream().toList().getLast();
        for (int i = 0; i < last; ++i) {
            builder.add(LootItem.lootTableItem((ItemLike)((ItemLike)index2blocks.get(i))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)partIndex, i))));
        }
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)builder));
    }

    protected LootTable.Builder drainPartDrop(Block block) {
        LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block))));
    }
}

