/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.datagen;

import com.portingdeadmods.nautec.Nautec;
import com.portingdeadmods.nautec.content.items.AquarineArmorItem;
import com.portingdeadmods.nautec.content.items.DivingSuitArmorItem;
import com.portingdeadmods.nautec.content.items.tools.AquarineAxeItem;
import com.portingdeadmods.nautec.content.items.tools.AquarineHoeItem;
import com.portingdeadmods.nautec.content.items.tools.AquarinePickaxeItem;
import com.portingdeadmods.nautec.content.items.tools.AquarineShovelItem;
import com.portingdeadmods.nautec.content.items.tools.AquarineSwordItem;
import com.portingdeadmods.nautec.content.items.tools.AquarineWrenchItem;
import com.portingdeadmods.nautec.content.recipes.utils.IngredientWithCount;
import com.portingdeadmods.nautec.data.NTDataComponents;
import com.portingdeadmods.nautec.datagen.recipeBuilder.AquaticCatalystChannelingRecipeBuilder;
import com.portingdeadmods.nautec.datagen.recipeBuilder.AugmentationRecipeBuilder;
import com.portingdeadmods.nautec.datagen.recipeBuilder.IncubationRecipeBuilder;
import com.portingdeadmods.nautec.datagen.recipeBuilder.ItemEtchingRecipeBuilder;
import com.portingdeadmods.nautec.datagen.recipeBuilder.ItemTransformationRecipeBuilder;
import com.portingdeadmods.nautec.datagen.recipeBuilder.MixingRecipeBuilder;
import com.portingdeadmods.nautec.datagen.recipeBuilder.MutationRecipeBuilder;
import com.portingdeadmods.nautec.registries.NTAugments;
import com.portingdeadmods.nautec.registries.NTBacterias;
import com.portingdeadmods.nautec.registries.NTBlocks;
import com.portingdeadmods.nautec.registries.NTFluids;
import com.portingdeadmods.nautec.registries.NTItems;
import com.portingdeadmods.nautec.utils.ranges.IntRange;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class RecipesProvider
extends RecipeProvider {
    public RecipesProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(@NotNull RecipeOutput pRecipeOutput) {
        RecipesProvider.aquaticCatalystRecipes(pRecipeOutput);
        RecipesProvider.aquarineSteelRecipes(pRecipeOutput);
        RecipesProvider.ancientItemsRecipes(pRecipeOutput);
        RecipesProvider.chemistryRecipes(pRecipeOutput);
        RecipesProvider.augmentationRecipes(pRecipeOutput);
        RecipesProvider.aquarineSteelToolsRecipes(pRecipeOutput);
        RecipesProvider.divingArmorRecipes(pRecipeOutput);
        RecipesProvider.aquarineSteelArmorRecipes(pRecipeOutput);
        RecipesProvider.buildingBlockRecipes(pRecipeOutput);
        RecipesProvider.utilityRecipes(pRecipeOutput);
        RecipesProvider.castIronRecipes(pRecipeOutput);
        RecipesProvider.miscItemsRecipes(pRecipeOutput);
        RecipesProvider.machineRecipes(pRecipeOutput);
        RecipesProvider.laserDeviceRecipes(pRecipeOutput);
        RecipesProvider.drainRecipes(pRecipeOutput);
        RecipesProvider.augmentationStationRecipes(pRecipeOutput);
        RecipesProvider.mutationRecipes(pRecipeOutput);
        RecipesProvider.incubationRecipes(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTItems.GLASS_VIAL.asItem(), (int)3).pattern("G G").pattern("G G").pattern(" G ").define(Character.valueOf('G'), (ItemLike)Items.GLASS).unlockedBy("has_item", RecipesProvider.has((ItemLike)Items.GLASS)).save(pRecipeOutput, Nautec.rl("glass_vial"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTItems.CLAW_ROBOT_ARM.asItem(), (int)1).pattern("AB ").pattern(" AB").pattern("  A").define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).define(Character.valueOf('B'), NTItems.CAST_IRON_ROD).unlockedBy("has_item", RecipesProvider.has(NTItems.AQUARINE_STEEL_INGOT)).save(pRecipeOutput, Nautec.rl("claw_robot_arm"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTItems.PRISM_MONOCLE.asItem(), (int)1).pattern("AAA").pattern("AP ").define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).define(Character.valueOf('P'), (ItemLike)Items.PRISMARINE_CRYSTALS).unlockedBy("has_item", RecipesProvider.has(NTItems.AQUARINE_STEEL_INGOT)).save(pRecipeOutput, Nautec.rl("prism_monocle"));
        RecipesProvider.brownPolymerRecipes(pRecipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.NAUTEC_GUIDE.get()), (int)1).requires((ItemLike)Items.BOOK).requires((ItemLike)NTItems.CAST_IRON_NUGGET.get(), 1).unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.CAST_IRON_NUGGET.get()))).save(pRecipeOutput, Nautec.rl("nautec_guide"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{NTBlocks.ANCHOR}), (RecipeCategory)RecipeCategory.MISC, (ItemStack)NTItems.CAST_IRON_INGOT.toStack(11), (float)0.2f, (int)400).unlockedBy("has_item", RecipesProvider.has((ItemLike)Items.IRON_INGOT)).save(pRecipeOutput, Nautec.rl("cast_iron_ingot_from_anchor_blasting"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{NTBlocks.OIL_BARREL}), (RecipeCategory)RecipeCategory.MISC, (ItemStack)NTItems.CAST_IRON_INGOT.toStack(5), (float)0.2f, (int)400).unlockedBy("has_item", RecipesProvider.has((ItemLike)Items.IRON_INGOT)).save(pRecipeOutput, Nautec.rl("cast_iron_ingot_from_oil_barrel_blasting"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{NTItems.CAST_IRON_COMPOUND}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.CAST_IRON_INGOT.get()), (float)0.2f, (int)100).unlockedBy("has_item", RecipesProvider.has((ItemLike)Items.IRON_INGOT)).save(pRecipeOutput, Nautec.rl("cast_iron_ingot_blasting"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{NTItems.CAST_IRON_COMPOUND}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.CAST_IRON_INGOT.get()), (float)0.2f, (int)200).unlockedBy("has_item", RecipesProvider.has((ItemLike)Items.IRON_INGOT)).save(pRecipeOutput, Nautec.rl("cast_iron_ingot_smelting"));
    }

    private static void aquaticCatalystRecipes(@NotNull RecipeOutput pRecipeOutput) {
        AquaticCatalystChannelingRecipeBuilder.newRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE_CRYSTALS})).powerAmount(1000).purity(0.8f).duration(160).save(pRecipeOutput, Nautec.rl("prismarine_crystals_to_ap"));
        AquaticCatalystChannelingRecipeBuilder.newRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE_SHARD})).powerAmount(2000).purity(0.4f).duration(160).save(pRecipeOutput, Nautec.rl("prismarine_shards_to_ap"));
        AquaticCatalystChannelingRecipeBuilder.newRecipe(Ingredient.of((ItemLike[])new ItemLike[]{NTItems.PRISMARINE_CRYSTAL_SHARD})).powerAmount(2400).purity(1.2f).duration(200).save(pRecipeOutput, Nautec.rl("prismarine_crystal_shards_to_ap"));
    }

    private static void aquarineSteelRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ItemTransformationRecipeBuilder.newRecipe(new ItemStack((ItemLike)NTItems.AQUARINE_STEEL_INGOT.get(), 1)).ingredient(new ItemStack((ItemLike)NTItems.AQUARINE_STEEL_COMPOUND.get())).purity(0.0f).duration(100).save(pRecipeOutput, Nautec.rl("aquarine_steel_ingot"));
        RecipesProvider.nineBlockStorageRecipes((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)NTBlocks.AQUARINE_STEEL_BLOCK.get()));
    }

    private static void augmentationStationRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.AUGMENTATION_STATION.asItem(), (int)1).pattern("ACA").pattern("PEP").pattern("AAA").define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).define(Character.valueOf('P'), NTBlocks.POLISHED_PRISMARINE).define(Character.valueOf('C'), NTItems.PRISMARINE_CRYSTAL_SHARD).define(Character.valueOf('E'), NTItems.ELDRITCH_HEART).unlockedBy("has_item", RecipesProvider.has(NTItems.PRISMARINE_CRYSTAL_SHARD)).save(pRecipeOutput, Nautec.rl("augmentation_station"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.AUGMENTATION_STATION_EXTENSION.asItem(), (int)2).pattern("ASA").pattern("APA").pattern("ACA").define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).define(Character.valueOf('P'), NTBlocks.POLISHED_PRISMARINE).define(Character.valueOf('C'), NTItems.LASER_CHANNELING_COIL).define(Character.valueOf('S'), NTItems.PRISMARINE_CRYSTAL_SHARD).unlockedBy("has_item", RecipesProvider.has(NTItems.PRISMARINE_CRYSTAL_SHARD)).save(pRecipeOutput, Nautec.rl("augmentation_station_extension"));
    }

    private static void drainRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.DRAIN.asItem(), (int)1).pattern("CVC").pattern("AGA").pattern("CCC").define(Character.valueOf('C'), NTItems.CAST_IRON_INGOT).define(Character.valueOf('V'), NTItems.VALVE).define(Character.valueOf('G'), NTItems.GEAR).define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).unlockedBy("has_item", RecipesProvider.has(NTItems.VALVE)).save(pRecipeOutput, Nautec.rl("drain"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.DRAIN_WALL.asItem(), (int)2).pattern("CCC").pattern("R R").pattern("CCC").define(Character.valueOf('C'), NTItems.CAST_IRON_INGOT).define(Character.valueOf('R'), NTItems.CAST_IRON_ROD).unlockedBy("has_item", RecipesProvider.has(NTItems.CAST_IRON_INGOT)).save(pRecipeOutput, Nautec.rl("drain_wall"));
    }

    private static void laserDeviceRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.PRISMARINE_RELAY.asItem(), (int)4).pattern("AAA").pattern("   ").pattern("AAA").define(Character.valueOf('A'), NTBlocks.POLISHED_PRISMARINE).unlockedBy("has_item", RecipesProvider.has(NTBlocks.POLISHED_PRISMARINE)).save(pRecipeOutput, Nautec.rl("prismarine_relay"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.LASER_JUNCTION.asItem(), (int)2).pattern("ARA").pattern("RHR").pattern("ARA").define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).define(Character.valueOf('R'), NTBlocks.PRISMARINE_RELAY).define(Character.valueOf('H'), (ItemLike)Items.HEART_OF_THE_SEA).unlockedBy("has_item", RecipesProvider.has(NTBlocks.PRISMARINE_RELAY)).save(pRecipeOutput, Nautec.rl("laser_junction"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.LONG_DISTANCE_LASER.asItem(), (int)1).pattern("DRD").pattern("PSP").pattern("PRP").define(Character.valueOf('D'), (ItemLike)Blocks.DARK_PRISMARINE).define(Character.valueOf('R'), NTBlocks.PRISMARINE_RELAY).define(Character.valueOf('P'), NTBlocks.POLISHED_PRISMARINE).define(Character.valueOf('S'), NTItems.PRISMARINE_CRYSTAL_SHARD).unlockedBy("has_item", RecipesProvider.has(NTBlocks.PRISMARINE_RELAY)).save(pRecipeOutput, Nautec.rl("long_distance_laser"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.AQUATIC_CATALYST.asItem(), (int)1).pattern("PCP").pattern("P P").pattern("PCP").define(Character.valueOf('C'), (ItemLike)Items.PRISMARINE_CRYSTALS).define(Character.valueOf('P'), NTBlocks.POLISHED_PRISMARINE).unlockedBy("has_item", RecipesProvider.has(NTBlocks.POLISHED_PRISMARINE)).save(pRecipeOutput, Nautec.rl("aquatic_catalyst"));
    }

    private static void machineRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)NTBlocks.MIXER.asItem()).pattern("DGD").pattern("PWP").pattern("PAP").define(Character.valueOf('G'), NTItems.GEAR).define(Character.valueOf('D'), NTBlocks.POLISHED_PRISMARINE).define(Character.valueOf('P'), NTBlocks.POLISHED_PRISMARINE).define(Character.valueOf('W'), NTItems.WHISK).define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).unlockedBy("has_item", RecipesProvider.has(NTItems.PRISMARINE_CRYSTAL_SHARD)).save(pRecipeOutput, Nautec.rl("mixer"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)NTBlocks.FISHING_STATION.asItem()).pattern("DAD").pattern("RGR").pattern("DAD").define(Character.valueOf('D'), NTBlocks.DARK_PRISMARINE_PILLAR).define(Character.valueOf('R'), NTItems.CAST_IRON_ROD).define(Character.valueOf('G'), NTItems.GEAR).define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).unlockedBy("has_item", RecipesProvider.has(NTItems.AQUARINE_STEEL_INGOT)).save(pRecipeOutput, Nautec.rl("fishing_station"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)NTBlocks.CHARGER.asItem()).pattern("PAP").pattern("DCD").define(Character.valueOf('P'), NTBlocks.POLISHED_PRISMARINE).define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).define(Character.valueOf('D'), (ItemLike)Blocks.DARK_PRISMARINE).define(Character.valueOf('C'), NTItems.LASER_CHANNELING_COIL).unlockedBy("has_item", RecipesProvider.has(NTItems.PRISMARINE_CRYSTAL_SHARD)).save(pRecipeOutput, Nautec.rl("charger"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)NTBlocks.INCUBATOR.asItem()).pattern("PGP").pattern("CAC").pattern("PLP").define(Character.valueOf('P'), NTBlocks.POLISHED_PRISMARINE).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('C'), (ItemLike)Items.PRISMARINE_CRYSTALS).define(Character.valueOf('A'), NTItems.AQUATIC_CHIP).define(Character.valueOf('L'), NTItems.LASER_CHANNELING_COIL).unlockedBy("has_item", RecipesProvider.has(NTItems.LASER_CHANNELING_COIL)).save(pRecipeOutput, Nautec.rl("incubator"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)NTBlocks.MUTATOR.asItem()).pattern("DCD").pattern("PBP").pattern("DCD").define(Character.valueOf('P'), NTItems.PETRI_DISH).define(Character.valueOf('B'), (ItemLike)NTFluids.EAS.getBucket()).define(Character.valueOf('C'), NTBlocks.BACTERIAL_CONTAINMENT_SHIELD).define(Character.valueOf('D'), NTBlocks.DARK_PRISMARINE_PILLAR).unlockedBy("has_item", RecipesProvider.has(NTBlocks.BACTERIAL_CONTAINMENT_SHIELD)).save(pRecipeOutput, Nautec.rl("mutator"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)NTBlocks.BACTERIAL_ANALYZER.asItem()).pattern("PLP").pattern("A A").pattern("A A").define(Character.valueOf('P'), NTBlocks.POLISHED_PRISMARINE).define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).define(Character.valueOf('L'), NTItems.PRISMARINE_LENS).unlockedBy("has_item", RecipesProvider.has(NTItems.PRISMARINE_LENS)).save(pRecipeOutput, Nautec.rl("bacterial_analyzer"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)NTBlocks.BIO_REACTOR.asItem()).pattern("CCC").pattern("PAP").pattern("PLP").define(Character.valueOf('P'), NTBlocks.POLISHED_PRISMARINE).define(Character.valueOf('A'), NTItems.AQUATIC_CHIP).define(Character.valueOf('C'), (ItemLike)Items.PRISMARINE_CRYSTALS).define(Character.valueOf('L'), NTItems.LASER_CHANNELING_COIL).unlockedBy("has_item", RecipesProvider.has(NTItems.AQUATIC_CHIP)).save(pRecipeOutput, Nautec.rl("bio_reactor"));
    }

    private static void ancientItemsRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ItemEtchingRecipeBuilder.newRecipe(NTItems.VALVE.toStack()).ingredient(NTItems.ANCIENT_VALVE.toStack()).duration(200).save(pRecipeOutput, Nautec.rl("valve"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemStack)NTItems.AQUATIC_CHIP.toStack()).requires(NTItems.DAMAGED_AQUATIC_CHIP).requires((ItemLike)Items.PRISMARINE_SHARD, 3).unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.DAMAGED_AQUATIC_CHIP.get()))).save(pRecipeOutput, Nautec.rl("aquatic_chip"));
        ItemEtchingRecipeBuilder.newRecipe(NTItems.GEAR.toStack()).ingredient(NTItems.RUSTY_GEAR.toStack()).duration(160).save(pRecipeOutput, Nautec.rl("gear"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.WHISK.get()), (int)1).requires((ItemLike)NTItems.BROKEN_WHISK.get()).requires((ItemLike)NTItems.CAST_IRON_NUGGET.get(), 4).unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.BROKEN_WHISK.get()))).save(pRecipeOutput, Nautec.rl("whisk"));
        ItemTransformationRecipeBuilder.newRecipe(NTItems.LASER_CHANNELING_COIL.toStack()).ingredient((ItemLike)NTItems.BURNT_COIL.get()).purity(1.5f).duration(200).save(pRecipeOutput, Nautec.rl("laser_channeling_coil"));
    }

    private static void aquarineSteelToolsRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarinePickaxeItem)NTItems.AQUARINE_PICKAXE.get()).getDefaultInstance()).pattern("AGA").pattern(" C ").pattern(" R ").unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()))).define(Character.valueOf('A'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('R'), (ItemLike)NTItems.CAST_IRON_ROD.get()).define(Character.valueOf('G'), (ItemLike)NTItems.GEAR.get()).define(Character.valueOf('C'), (ItemLike)NTItems.LASER_CHANNELING_COIL.get()).save(pRecipeOutput, Nautec.rl("aquarine_pickaxe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarineShovelItem)NTItems.AQUARINE_SHOVEL.get()).getDefaultInstance()).pattern(" A ").pattern(" G ").pattern(" R ").unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()))).define(Character.valueOf('A'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('G'), (ItemLike)NTItems.GEAR.get()).define(Character.valueOf('R'), (ItemLike)NTItems.CAST_IRON_ROD.get()).save(pRecipeOutput, Nautec.rl("aquarine_shovel"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarineAxeItem)NTItems.AQUARINE_AXE.get()).getDefaultInstance()).pattern("AG ").pattern("AR ").pattern(" R ").unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()))).define(Character.valueOf('A'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('G'), (ItemLike)NTItems.GEAR.get()).define(Character.valueOf('R'), (ItemLike)NTItems.CAST_IRON_ROD.get()).save(pRecipeOutput, Nautec.rl("aquarine_axe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarineHoeItem)NTItems.AQUARINE_HOE.get()).getDefaultInstance()).pattern("AA ").pattern(" C ").pattern(" R ").unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()))).define(Character.valueOf('A'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('R'), (ItemLike)NTItems.CAST_IRON_ROD.get()).define(Character.valueOf('C'), (ItemLike)NTItems.LASER_CHANNELING_COIL.get()).save(pRecipeOutput, Nautec.rl("aquarine_hoe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarineSwordItem)NTItems.AQUARINE_SWORD.get()).getDefaultInstance()).pattern(" A ").pattern(" A ").pattern(" C ").unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()))).define(Character.valueOf('A'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('C'), (ItemLike)NTItems.LASER_CHANNELING_COIL.get()).save(pRecipeOutput, Nautec.rl("aquarine_sword"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarineWrenchItem)((Object)NTItems.AQUARINE_WRENCH.get())).getDefaultInstance()).pattern("A A").pattern(" A ").pattern(" A ").unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()))).define(Character.valueOf('A'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).save(pRecipeOutput, Nautec.rl("aquarine_wrench"));
    }

    private static void utilityRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.PRISMATIC_BATTERY.get()), (int)1).pattern("SRS").pattern("ACA").define(Character.valueOf('A'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('S'), (ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.get()).define(Character.valueOf('C'), (ItemLike)NTItems.LASER_CHANNELING_COIL.get()).unlockedBy("has_item", RecipesProvider.has(NTItems.PRISMARINE_CRYSTAL_SHARD)).save(pRecipeOutput, Nautec.rl("prismatic_battery"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.CROWBAR.get()), (int)1).pattern(" LR").pattern("LRL").pattern("RL ").define(Character.valueOf('R'), (ItemLike)NTItems.CAST_IRON_ROD.get()).define(Character.valueOf('L'), Tags.Items.DYES_BLUE).unlockedBy("has_item", RecipesProvider.has(NTItems.CAST_IRON_ROD)).save(pRecipeOutput, Nautec.rl("crowbar"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.GRAFTING_TOOL.get()), (int)1).pattern(" R").pattern("I ").define(Character.valueOf('R'), (ItemLike)NTItems.CAST_IRON_ROD.get()).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("has_item", RecipesProvider.has(NTItems.CAST_IRON_ROD)).save(pRecipeOutput, Nautec.rl("grafting_tool"));
    }

    private static void miscItemsRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.BROWN_POLYMER.get()), (int)2).requires((ItemLike)Items.DRIED_KELP).requires((ItemLike)Items.BROWN_DYE).unlockedBy("has_item", RecipesProvider.has((ItemLike)Items.DRIED_KELP)).save(pRecipeOutput, Nautec.rl("brown_polymer"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.AQUARINE_STEEL_COMPOUND.get()), (int)2).requires((ItemLike)Items.RAW_IRON).requires((ItemLike)Items.PRISMARINE_CRYSTALS).unlockedBy("has_item", RecipesProvider.has((ItemLike)Items.PRISMARINE_CRYSTALS)).save(pRecipeOutput, Nautec.rl("aquarine_steel_compound"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.CAST_IRON_COMPOUND.get()), (int)2).requires((ItemLike)Items.RAW_IRON).requires(ItemTags.COALS).requires(ItemTags.COALS).unlockedBy("has_raw_rion", RecipesProvider.has((ItemLike)Items.RAW_IRON)).save(pRecipeOutput, Nautec.rl("cast_iron_compound"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.PRISMARINE_LENS.get())).pattern(" A ").pattern("AGA").pattern(" A ").define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).define(Character.valueOf('G'), Tags.Items.GLASS_PANES_COLORLESS).unlockedBy("has_item", RecipesProvider.has(NTItems.AQUARINE_STEEL_INGOT)).save(pRecipeOutput, Nautec.rl("prismarine_lens"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.PETRI_DISH.get())).pattern("G G").pattern("GGG").define(Character.valueOf('G'), Tags.Items.GLASS_PANES_COLORLESS).unlockedBy("has_item", RecipesProvider.has((TagKey)Tags.Items.GLASS_PANES_COLORLESS)).save(pRecipeOutput, Nautec.rl("petri_dish"));
    }

    private static void castIronRecipes(@NotNull RecipeOutput pRecipeOutput) {
        RecipesProvider.nineBlockStorageRecipes((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.MISC, NTItems.CAST_IRON_NUGGET, (RecipeCategory)RecipeCategory.MISC, NTItems.CAST_IRON_INGOT, (String)"nautec:cast_iron_ingot_from_nuggets", null, (String)"nautec:nuggets_from_cast_iron_ingot", null);
        RecipesProvider.nineBlockStorageRecipes((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.MISC, NTItems.CAST_IRON_INGOT, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, NTBlocks.CAST_IRON_BLOCK, (String)"nautec:cast_iron_block_from_ingots", null, (String)"nautec:ingots_from_cast_iron_block", null);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.CAST_IRON_ROD.get()), (int)4).pattern("C").pattern("C").define(Character.valueOf('C'), (ItemLike)NTItems.CAST_IRON_INGOT.asItem()).unlockedBy("has_item", RecipesProvider.has((ItemLike)Items.DEEPSLATE)).save(pRecipeOutput, Nautec.rl("cast_iron_rod"));
    }

    private static void buildingBlockRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)NTBlocks.BACTERIAL_CONTAINMENT_SHIELD.asItem(), (int)2).pattern("APA").pattern("PCP").pattern("APA").define(Character.valueOf('P'), (ItemLike)NTBlocks.POLISHED_PRISMARINE.asItem()).define(Character.valueOf('A'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.asItem()).define(Character.valueOf('C'), (ItemLike)Items.PRISMARINE_CRYSTALS.asItem()).unlockedBy("has_item", RecipesProvider.has((ItemLike)NTItems.AQUARINE_STEEL_INGOT.asItem())).save(pRecipeOutput, Nautec.rl("bacteria_containment_shield_from_prismarine_crystals"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)NTBlocks.BACTERIAL_CONTAINMENT_SHIELD.asItem(), (int)4).pattern("APA").pattern("PCP").pattern("APA").define(Character.valueOf('P'), (ItemLike)NTBlocks.POLISHED_PRISMARINE.asItem()).define(Character.valueOf('A'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.asItem()).define(Character.valueOf('C'), (ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.asItem()).unlockedBy("has_item", RecipesProvider.has((ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.asItem())).save(pRecipeOutput, Nautec.rl("bacteria_containment_shield_from_prismarine_crystal_shard"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)NTBlocks.CHISELED_DARK_PRISMARINE.asItem(), (int)4).pattern("DD").pattern("DD").define(Character.valueOf('D'), (ItemLike)Blocks.DARK_PRISMARINE.asItem()).unlockedBy("has_item", RecipesProvider.has((ItemLike)Blocks.DARK_PRISMARINE)).save(pRecipeOutput, Nautec.rl("chiseled_dark_prismarine"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)NTBlocks.POLISHED_PRISMARINE.asItem(), (int)4).pattern("DD").pattern("DD").define(Character.valueOf('D'), (ItemLike)Blocks.PRISMARINE.asItem()).unlockedBy("has_item", RecipesProvider.has((ItemLike)Blocks.DARK_PRISMARINE)).save(pRecipeOutput, Nautec.rl("polished_prismarine"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)NTBlocks.DARK_PRISMARINE_PILLAR.asItem(), (int)2).pattern("D").pattern("D").define(Character.valueOf('D'), (ItemLike)Blocks.DARK_PRISMARINE.asItem()).unlockedBy("has_item", RecipesProvider.has((ItemLike)Blocks.DARK_PRISMARINE)).save(pRecipeOutput, Nautec.rl("dark_prismarine_pillar"));
    }

    private static void brownPolymerRecipes(RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, NTBlocks.BROWN_POLYMER_BLOCK).pattern("BB").pattern("BB").define(Character.valueOf('B'), (ItemLike)NTItems.BROWN_POLYMER.asItem()).unlockedBy("has_item", RecipesProvider.has(NTItems.BROWN_POLYMER)).save(pRecipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, NTItems.BROWN_POLYMER, (int)4).requires(NTBlocks.BROWN_POLYMER_BLOCK).unlockedBy("has_item", RecipesProvider.has(NTBlocks.BROWN_POLYMER_BLOCK)).save(pRecipeOutput, Nautec.rl("brown_polymer_from_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BOOK, (int)2).requires(NTItems.BROWN_POLYMER).requires((ItemLike)Items.PAPER, 3).unlockedBy("has_item", RecipesProvider.has(NTItems.BROWN_POLYMER)).save(pRecipeOutput, Nautec.rl("book_from_brown_polymer"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.BROWN_BANNER, (int)2).pattern("BBB").pattern("BBB").pattern(" S ").define(Character.valueOf('B'), (ItemLike)NTItems.BROWN_POLYMER.get()).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.BROWN_POLYMER.get()))).save(pRecipeOutput, Nautec.rl("banner_from_brown_polymer"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.ITEM_FRAME, (int)2).pattern("SSS").pattern("SBS").pattern("SSS").define(Character.valueOf('B'), (ItemLike)NTItems.BROWN_POLYMER.get()).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.BROWN_POLYMER.get()))).save(pRecipeOutput, Nautec.rl("item_frame_from_brown_polymer"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.BROWN_BED).pattern("BBB").pattern("PPP").define(Character.valueOf('B'), (ItemLike)NTItems.BROWN_POLYMER.get()).define(Character.valueOf('P'), ItemTags.PLANKS).unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.BROWN_POLYMER.get()))).save(pRecipeOutput, Nautec.rl("bed_from_brown_polymer"));
    }

    private static void aquarineSteelArmorRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarineArmorItem)NTItems.AQUARINE_HELMET.get()).getDefaultInstance()).pattern("ICI").pattern("I I").define(Character.valueOf('I'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('C'), (ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.get()).unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.get()))).save(pRecipeOutput, Nautec.rl("aquarine_helmet"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarineArmorItem)NTItems.AQUARINE_CHESTPLATE.get()).getDefaultInstance()).pattern("I I").pattern("ICI").pattern("IVI").define(Character.valueOf('I'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('C'), (ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.get()).define(Character.valueOf('V'), (ItemLike)NTItems.VALVE.get()).unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.get()))).save(pRecipeOutput, Nautec.rl("aquarine_chestplate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarineArmorItem)NTItems.AQUARINE_LEGGINGS.get()).getDefaultInstance()).pattern("IVI").pattern("C C").pattern("I I").define(Character.valueOf('I'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('C'), (ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.get()).define(Character.valueOf('V'), (ItemLike)NTItems.VALVE.get()).unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.get()))).save(pRecipeOutput, Nautec.rl("aquarine_leggings"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarineArmorItem)NTItems.AQUARINE_BOOTS.get()).getDefaultInstance()).pattern("C C").pattern("I I").define(Character.valueOf('I'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('C'), (ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.get()).unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.get()))).save(pRecipeOutput, Nautec.rl("aquarine_boots"));
    }

    private static void divingArmorRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((DivingSuitArmorItem)((Object)NTItems.DIVING_HELMET.get())).getDefaultInstance()).pattern("CCC").pattern("CGC").define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT.asItem()).define(Character.valueOf('G'), (ItemLike)Items.GLASS_PANE.asItem()).unlockedBy("has_item", RecipesProvider.has((ItemLike)Items.COPPER_INGOT)).save(pRecipeOutput, Nautec.rl("diving_helmet"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((DivingSuitArmorItem)((Object)NTItems.DIVING_CHESTPLATE.get())).getDefaultInstance()).pattern("C C").pattern("BCB").pattern("BBB").define(Character.valueOf('B'), (ItemLike)NTItems.BROWN_POLYMER.get()).define(Character.valueOf('C'), Tags.Items.INGOTS_COPPER).unlockedBy("has_item", RecipesProvider.has(NTItems.BROWN_POLYMER)).save(pRecipeOutput, Nautec.rl("diving_chestplate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((DivingSuitArmorItem)((Object)NTItems.DIVING_LEGGINGS.get())).getDefaultInstance()).pattern("BBB").pattern("B B").pattern("B B").define(Character.valueOf('B'), (ItemLike)NTItems.BROWN_POLYMER.get()).unlockedBy("has_item", RecipesProvider.has(NTItems.BROWN_POLYMER)).save(pRecipeOutput, Nautec.rl("diving_leggings"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((DivingSuitArmorItem)((Object)NTItems.DIVING_BOOTS.get())).getDefaultInstance()).pattern("B B").pattern("B B").define(Character.valueOf('B'), (ItemLike)NTItems.BROWN_POLYMER.get()).unlockedBy("has_item", RecipesProvider.has(NTItems.BROWN_POLYMER)).save(pRecipeOutput, Nautec.rl("diving_boots"));
        ItemStack divingChestplate = ((DivingSuitArmorItem)((Object)NTItems.DIVING_CHESTPLATE.get())).getDefaultInstance();
        divingChestplate.set(NTDataComponents.OXYGEN, (Object)600);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)divingChestplate).pattern("GGG").pattern("GDG").pattern("GGG").unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.DIVING_CHESTPLATE.get()))).define(Character.valueOf('G'), (ItemLike)NTItems.AIR_BOTTLE.get()).define(Character.valueOf('D'), (ItemLike)NTItems.DIVING_CHESTPLATE.get()).save(pRecipeOutput, Nautec.rl("diving_chestplate_oxygen"));
        ItemStack inputCrate = NTBlocks.RUSTY_CRATE.toStack();
        ItemStack outputCrate = NTBlocks.CRATE.toStack();
        ItemEtchingRecipeBuilder.newRecipe(outputCrate).ingredient(inputCrate).duration(200).save(pRecipeOutput, Nautec.rl("crate"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTFluids.ETCHING_ACID.getBucket()).requires((ItemLike)Items.POISONOUS_POTATO).requires((ItemLike)Items.GUNPOWDER).requires((ItemLike)Items.BONE_MEAL).requires((ItemLike)Items.WATER_BUCKET).requires((ItemLike)Items.PUFFERFISH).unlockedBy("has_item", RecipesProvider.has((ItemLike)Items.POISONOUS_POTATO)).save(pRecipeOutput, Nautec.rl("etching_acid_crafting"));
    }

    private static void chemistryRecipes(@NotNull RecipeOutput pRecipeOutput) {
        MixingRecipeBuilder.newRecipe(ItemStack.EMPTY).ingredients(RecipesProvider.iwcFromItemLike(Items.DRIED_KELP, 4), RecipesProvider.iwcFromItemLike(Items.SLIME_BALL, 2), RecipesProvider.iwcFromItemLike(Items.PRISMARINE_CRYSTALS, 1), RecipesProvider.iwcFromItemLike(Items.SEAGRASS, 5)).duration(200).fluidIngredient(new FluidStack((Fluid)NTFluids.SALT_WATER.getStillFluid(), 1000)).fluidResult(new FluidStack((Fluid)NTFluids.EAS.getStillFluid(), 1000)).save(pRecipeOutput, Nautec.rl("eas"));
        MixingRecipeBuilder.newRecipe(ItemStack.EMPTY).ingredients(RecipesProvider.iwcFromItemLike(Items.PUFFERFISH, 1), RecipesProvider.iwcFromItemLike(Items.GUNPOWDER, 1), RecipesProvider.iwcFromItemLike(Items.BONE_MEAL, 1)).duration(150).fluidIngredient(new FluidStack((Fluid)NTFluids.SALT_WATER.getStillFluid(), 1000)).fluidResult(new FluidStack((Fluid)NTFluids.ETCHING_ACID.getStillFluid(), 1000)).save(pRecipeOutput, Nautec.rl("etching_acid_mixing"));
        MixingRecipeBuilder.newRecipe(NTItems.AQUARINE_STEEL_COMPOUND.toStack(5)).ingredients(RecipesProvider.iwcFromItemLike(Items.RAW_IRON, 2), RecipesProvider.iwcFromItemLike(Items.PRISMARINE_CRYSTALS, 1)).duration(100).fluidIngredient(new FluidStack((Fluid)NTFluids.SALT_WATER.getStillFluid(), 1000)).fluidResult(FluidStack.EMPTY).save(pRecipeOutput, Nautec.rl("aquarine_steel_compound_mixing"));
    }

    private static void augmentationRecipes(@NotNull RecipeOutput pRecipeOutput) {
        AugmentationRecipeBuilder.newRecipe(NTAugments.DOLPHIN_FIN.get()).augmentItem((Item)NTItems.DOLPHIN_FIN.get(), "Greatly improved swimming speed").ingredients(IngredientWithCount.fromItemLike((ItemLike)NTItems.DOLPHIN_FIN.get())).save(pRecipeOutput, Nautec.rl("dolphin_fin"));
        AugmentationRecipeBuilder.newRecipe(NTAugments.DROWNED_LUNG.get()).augmentItem((Item)NTItems.DROWNED_LUNGS.get(), "Unlimited underwater breathing").ingredients(IngredientWithCount.fromItemLike((ItemLike)NTItems.DROWNED_LUNGS.get())).save(pRecipeOutput, Nautec.rl("drowned_lung"));
        AugmentationRecipeBuilder.newRecipe(NTAugments.GUARDIAN_EYE.get()).augmentItem((Item)NTItems.GUARDIAN_EYE.get(), "Shoots lasers at enemies you are looking at").ingredients(IngredientWithCount.fromItemLike((ItemLike)NTItems.GUARDIAN_EYE.get())).save(pRecipeOutput, Nautec.rl("guardian_eye"));
        AugmentationRecipeBuilder.newRecipe(NTAugments.ELDRITCH_HEART.get()).augmentItem((Item)NTItems.ELDRITCH_HEART.get(), "Increased health regeneration when underwater").ingredients(IngredientWithCount.fromItemLike((ItemLike)NTItems.ELDRITCH_HEART.get())).save(pRecipeOutput, Nautec.rl("eldritch_heart"));
    }

    private static void mutationRecipes(RecipeOutput output) {
        new MutationRecipeBuilder(NTBacterias.THERMOPHILES, NTBacterias.LITHOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.LITHOPHILES, NTBacterias.CARBOPHAGES, Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.LITHOPHILES, NTBacterias.SILICOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.SAND}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.LITHOPHILES, NTBacterias.CALCIOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE_MEAL}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.CARBOPHAGES, NTBacterias.METALLOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.COPPER_INGOT}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.METALLOPHILES, NTBacterias.ACIDOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.ACIDOPHILES, NTBacterias.SULFUROPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.GUNPOWDER}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.METALLOPHILES, NTBacterias.AZURITOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.LAPIS_LAZULI}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.METALLOPHILES, NTBacterias.FERROPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.FERROPHILES, NTBacterias.AURROPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.AURROPHILES, NTBacterias.ADAMANTOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.ADAMANTOPHILES, NTBacterias.SMARAGDOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.EMERALD}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.METHANOGENS, NTBacterias.CARNIVOROUS_BACTERIA, Ingredient.of((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.METHANOGENS, NTBacterias.RED_MYCOTROPHIC_BACTERIA, Ingredient.of((ItemLike[])new ItemLike[]{Items.RED_MUSHROOM_BLOCK}), 20.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.METHANOGENS, NTBacterias.BROWN_MYCOTROPHIC_BACTERIA, Ingredient.of((ItemLike[])new ItemLike[]{Items.BROWN_MUSHROOM_BLOCK}), 20.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.BROWN_MYCOTROPHIC_BACTERIA, NTBacterias.WARPED_MICROBES, Ingredient.of((ItemLike[])new ItemLike[]{Items.WARPED_FUNGUS}), 3.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.RED_MYCOTROPHIC_BACTERIA, NTBacterias.WARPED_MICROBES, Ingredient.of((ItemLike[])new ItemLike[]{Items.WARPED_FUNGUS}), 3.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.BROWN_MYCOTROPHIC_BACTERIA, NTBacterias.CRIMSON_MICROBES, Ingredient.of((ItemLike[])new ItemLike[]{Items.CRIMSON_FUNGUS}), 3.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.RED_MYCOTROPHIC_BACTERIA, NTBacterias.CRIMSON_MICROBES, Ingredient.of((ItemLike[])new ItemLike[]{Items.CRIMSON_FUNGUS}), 3.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.LIGNOCYTES, NTBacterias.CRIMSON_LIGNOCYTES, Ingredient.of((ItemLike[])new ItemLike[]{Items.CRIMSON_STEM}), 3.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.LIGNOCYTES, NTBacterias.WARPED_LIGNOCYTES, Ingredient.of((ItemLike[])new ItemLike[]{Items.WARPED_STEM}), 3.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.METHANOGENS, NTBacterias.LIGNOCYTES, Ingredient.of((ItemLike[])new ItemLike[]{Items.OAK_LOG}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.LIGNOCYTES, NTBacterias.DARK_LIGNOCYTES, Ingredient.of((ItemLike[])new ItemLike[]{Items.DARK_OAK_LOG}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.LIGNOCYTES, NTBacterias.ACACIOPHYLES, Ingredient.of((ItemLike[])new ItemLike[]{Items.ACACIA_LOG}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.LIGNOCYTES, NTBacterias.JUNGLOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.JUNGLE_LOG}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.LIGNOCYTES, NTBacterias.BOREOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.SPRUCE_LOG}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.LIGNOCYTES, NTBacterias.BETULOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.BIRCH_LOG}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.LIGNOCYTES, NTBacterias.RHIZOPHORA_LIGNOCYTES, Ingredient.of((ItemLike[])new ItemLike[]{Items.MANGROVE_LOG}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.LIGNOCYTES, NTBacterias.PRUNUS_LIGNOCYTES, Ingredient.of((ItemLike[])new ItemLike[]{Items.CHERRY_LOG}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.CYANOBACTERIA, NTBacterias.PHOTOTROPHS, Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR_CANE}), 10.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.PHOTOTROPHS, NTBacterias.CACTOPHYLES, Ingredient.of((ItemLike[])new ItemLike[]{Items.CACTUS}), 10.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.HALOBACTERIA, NTBacterias.HALOTROPHS, Ingredient.of((ItemLike[])new ItemLike[]{Items.KELP}), 25.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.HALOBACTERIA, NTBacterias.ALGAEFORMERS, Ingredient.of((ItemLike[])new ItemLike[]{Items.SEAGRASS}), 25.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.ALGAEFORMERS, NTBacterias.CRYOBIONTS, Ingredient.of((ItemLike[])new ItemLike[]{Items.BLUE_ICE}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.HALOTROPHS, NTBacterias.PHOTOTROPHS, Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR_CANE}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.PHOTOTROPHS, NTBacterias.RHIZOBACTERIA, Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT}), 5.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.RHIZOBACTERIA, NTBacterias.BETA_PHYLOBACTERIA, Ingredient.of((ItemLike[])new ItemLike[]{Items.BEETROOT}), 10.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.RHIZOBACTERIA, NTBacterias.CAROTOPHYLES, Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), 10.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.RHIZOBACTERIA, NTBacterias.SOLANOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.POTATO}), 10.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.RHIZOBACTERIA, NTBacterias.CUCURBITOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.PUMPKIN}), 10.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.CUCURBITOPHILES, NTBacterias.MELOPHAGES, Ingredient.of((ItemLike[])new ItemLike[]{Items.MELON_SLICE}), 10.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.RHIZOBACTERIA, NTBacterias.BAMBOOPHAGES, Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO}), 10.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.JUNGLOPHILES, NTBacterias.COCOAPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.COCOA_BEANS}), 10.0f).save(output);
        new MutationRecipeBuilder(NTBacterias.RHIZOBACTERIA, NTBacterias.BRYOPHYTOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.MOSS_BLOCK}), 5.0f).save(output);
    }

    private static void incubationRecipes(RecipeOutput output) {
        new IncubationRecipeBuilder(NTBacterias.LIGNOCYTES, Ingredient.of((ItemLike[])new ItemLike[]{Items.OAK_LOG}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.DARK_LIGNOCYTES, Ingredient.of((ItemLike[])new ItemLike[]{Items.DARK_OAK_LOG}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.ACACIOPHYLES, Ingredient.of((ItemLike[])new ItemLike[]{Items.ACACIA_LOG}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.JUNGLOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.JUNGLE_LOG}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.BOREOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.SPRUCE_LOG}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.BETULOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.BIRCH_LOG}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.CRIMSON_LIGNOCYTES, Ingredient.of((ItemLike[])new ItemLike[]{Items.CRIMSON_STEM}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.WARPED_LIGNOCYTES, Ingredient.of((ItemLike[])new ItemLike[]{Items.WARPED_STEM}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.RHIZOPHORA_LIGNOCYTES, Ingredient.of((ItemLike[])new ItemLike[]{Items.MANGROVE_LOG}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.PRUNUS_LIGNOCYTES, Ingredient.of((ItemLike[])new ItemLike[]{Items.CHERRY_LOG}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.SILICOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.SAND}), IntRange.of(8, 25), 0.05f).save(output);
        new IncubationRecipeBuilder(NTBacterias.LITHOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE}), IntRange.of(8, 25), 0.05f).save(output);
        new IncubationRecipeBuilder(NTBacterias.METALLOPHILES, Ingredient.of((TagKey)Tags.Items.ORES_COPPER), IntRange.of(8, 25), 0.1f).save(output);
        new IncubationRecipeBuilder(NTBacterias.FERROPHILES, Ingredient.of((TagKey)Tags.Items.ORES_IRON), IntRange.of(8, 25), 0.1f).save(output);
        new IncubationRecipeBuilder(NTBacterias.AURROPHILES, Ingredient.of((TagKey)Tags.Items.ORES_GOLD), IntRange.of(8, 25), 0.1f).save(output);
        new IncubationRecipeBuilder(NTBacterias.ACIDOPHILES, Ingredient.of((TagKey)Tags.Items.ORES_REDSTONE), IntRange.of(8, 25), 0.1f).save(output);
        new IncubationRecipeBuilder(NTBacterias.ADAMANTOPHILES, Ingredient.of((TagKey)Tags.Items.ORES_DIAMOND), IntRange.of(8, 25), 0.1f).save(output);
        new IncubationRecipeBuilder(NTBacterias.SMARAGDOPHILES, Ingredient.of((TagKey)Tags.Items.ORES_EMERALD), IntRange.of(8, 25), 0.1f).save(output);
        new IncubationRecipeBuilder(NTBacterias.AZURITOPHILES, Ingredient.of((TagKey)Tags.Items.ORES_LAPIS), IntRange.of(8, 25), 0.1f).save(output);
        new IncubationRecipeBuilder(NTBacterias.CARBOPHAGES, Ingredient.of((TagKey)Tags.Items.ORES_COAL), IntRange.of(8, 25), 0.1f).save(output);
        new IncubationRecipeBuilder(NTBacterias.CALCIOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE_BLOCK}), IntRange.of(8, 25), 0.1f).save(output);
        new IncubationRecipeBuilder(NTBacterias.PHOTOTROPHS, Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR_CANE}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.RED_MYCOTROPHIC_BACTERIA, Ingredient.of((ItemLike[])new ItemLike[]{Items.RED_MUSHROOM_BLOCK}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.BROWN_MYCOTROPHIC_BACTERIA, Ingredient.of((ItemLike[])new ItemLike[]{Items.BROWN_MUSHROOM_BLOCK}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.HALOTROPHS, Ingredient.of((ItemLike[])new ItemLike[]{Items.SAND}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.BRYOPHYTOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.MOSS_BLOCK}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.ALGAEFORMERS, Ingredient.of((ItemLike[])new ItemLike[]{Items.KELP}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.RHIZOBACTERIA, Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.SOLANOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.POTATO}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.BAMBOOPHAGES, Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.CACTOPHYLES, Ingredient.of((ItemLike[])new ItemLike[]{Items.CACTUS}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.CAROTOPHYLES, Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.CUCURBITOPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.PUMPKIN}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.BETA_PHYLOBACTERIA, Ingredient.of((ItemLike[])new ItemLike[]{Items.BEETROOT}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.MELOPHAGES, Ingredient.of((ItemLike[])new ItemLike[]{Items.MELON_SLICE}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.CRIMSON_MICROBES, Ingredient.of((ItemLike[])new ItemLike[]{Items.CRIMSON_NYLIUM}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.WARPED_MICROBES, Ingredient.of((ItemLike[])new ItemLike[]{Items.WARPED_NYLIUM}), IntRange.of(10, 30), 0.07f).save(output);
        new IncubationRecipeBuilder(NTBacterias.SULFUROPHILES, Ingredient.of((ItemLike[])new ItemLike[]{Items.GUNPOWDER}), IntRange.of(5, 15), 0.1f).save(output);
        new IncubationRecipeBuilder(NTBacterias.CRYOBIONTS, Ingredient.of((ItemLike[])new ItemLike[]{Items.PACKED_ICE}), IntRange.of(5, 15), 0.1f).save(output);
        new IncubationRecipeBuilder(NTBacterias.CARNIVOROUS_BACTERIA, Ingredient.of((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH}), IntRange.of(5, 15), 0.1f).save(output);
    }

    @NotNull
    private static IngredientWithCount iwcFromItemLike(Item item, int count) {
        return IngredientWithCount.fromItemLike((ItemLike)item, count);
    }
}

