/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.datagen;

import com.portingdeadmods.nautec.api.bacteria.Bacteria;
import com.portingdeadmods.nautec.data.NTDataMaps;
import com.portingdeadmods.nautec.data.maps.BacteriaObtainValue;
import com.portingdeadmods.nautec.registries.NTBacterias;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.DataMapProvider;

public class NTDataMapProvider
extends DataMapProvider {
    protected NTDataMapProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    protected void gather() {
        this.obtainBacteria(Blocks.STONE, NTBacterias.CYANOBACTERIA, (TagKey<Biome>)BiomeTags.IS_OCEAN, 0.4f);
        this.obtainBacteria(Blocks.PODZOL, NTBacterias.METHANOGENS, (TagKey<Biome>)BiomeTags.IS_FOREST, 0.4f);
        this.obtainBacteria(Blocks.SAND, NTBacterias.HALOBACTERIA, (TagKey<Biome>)BiomeTags.IS_BEACH, 0.4f);
        this.obtainBacteria(Blocks.NETHERRACK, NTBacterias.THERMOPHILES, (TagKey<Biome>)BiomeTags.IS_NETHER, 0.4f);
    }

    private void obtainBacteria(Block block, ResourceKey<Bacteria> bacteria, TagKey<Biome> biome, float chance) {
        this.builder(NTDataMaps.BACTERIA_OBTAINING).add((Holder)block.builtInRegistryHolder(), (Object)new BacteriaObtainValue(bacteria, biome, chance), false, new ICondition[0]);
    }
}

