/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.datagen;

import com.portingdeadmods.nautec.api.multiblocks.Multiblock;
import com.portingdeadmods.nautec.content.blocks.multiblock.controller.AugmentationStationBlock;
import com.portingdeadmods.nautec.content.blocks.multiblock.part.DrainPartBlock;
import com.portingdeadmods.nautec.content.multiblocks.AugmentationStationMultiblock;
import com.portingdeadmods.nautec.content.multiblocks.BioReactorMultiblock;
import com.portingdeadmods.nautec.content.multiblocks.DrainMultiblock;
import com.portingdeadmods.nautec.datagen.BlockModelProvider;
import com.portingdeadmods.nautec.registries.NTBlocks;
import com.portingdeadmods.nautec.registries.NTMultiblocks;
import java.util.Iterator;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import org.apache.commons.lang3.IntegerRange;
import org.jetbrains.annotations.NotNull;

public class MultiblockModelHelper {
    private final BlockModelProvider bmp;

    public MultiblockModelHelper(BlockModelProvider bmp) {
        this.bmp = bmp;
    }

    public void augmentationStationController(AugmentationStationBlock augmentationStationBlock) {
        ModelFile.ExistingModelFile formedModel = this.bmp.models().getExistingFile(this.bmp.existingModelFile("multiblock/augmentation_station_4"));
        ((VariantBlockStateBuilder)this.bmp.getVariantBuilder((Block)augmentationStationBlock).partialState().with((Property)Multiblock.FORMED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)formedModel).addModel()).partialState().with((Property)Multiblock.FORMED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.unformedAugmentationStationPart((Block)augmentationStationBlock, "controller")).addModel();
    }

    public void augmentationStationExtension(Block augmentationStationExtensionBlock) {
        VariantBlockStateBuilder builder = this.bmp.getVariantBuilder(augmentationStationExtensionBlock);
        builder.partialState().with((Property)Multiblock.FORMED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.unformedAugmentationStationPart(augmentationStationExtensionBlock, "extension")).addModel();
        for (Direction dir : BlockStateProperties.HORIZONTAL_FACING.getPossibleValues()) {
            builder.partialState().with((Property)Multiblock.FORMED, (Comparable)Boolean.valueOf(true)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)dir).modelForState().modelFile((ModelFile)this.bmp.models().getExistingFile(this.bmp.existingModelFile("multiblock/augmentation_station_extension"))).rotationY(((int)dir.toYRot() + 180) % 360).addModel();
        }
    }

    public void augmentationStationPart(Block augmentationStationPartBlock, IntegerRange range) {
        VariantBlockStateBuilder builder = this.bmp.getVariantBuilder(augmentationStationPartBlock);
        builder.partialState().with((Property)Multiblock.FORMED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(this.drainPartModel(augmentationStationPartBlock, 0, false)).addModel();
        for (int i = ((Integer)range.getMinimum()).intValue(); i <= (Integer)range.getMaximum(); ++i) {
            ModelFile.ExistingModelFile formedModel = this.bmp.models().getExistingFile(this.bmp.existingModelFile("multiblock/augmentation_station_" + (8 - i)));
            int index = i;
            if (i == 0 || i == 3 || i == 6) {
                index += 2;
            } else if (i == 2 || i == 5 || i == 8) {
                index -= 2;
            }
            builder.partialState().with((Property)Multiblock.FORMED, (Comparable)Boolean.valueOf(true)).with((Property)AugmentationStationMultiblock.AS_PART, (Comparable)Integer.valueOf(index)).modelForState().modelFile((ModelFile)formedModel).addModel();
        }
    }

    @NotNull
    public BlockModelBuilder unformedAugmentationStationPart(Block augmentationStationController, String part) {
        Multiblock multiblock = NTMultiblocks.AUGMENTATION_STATION.get();
        BlockModelBuilder builder = (BlockModelBuilder)this.bmp.models().withExistingParent(this.bmp.name(augmentationStationController), "cube");
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)builder.texture("up", this.bmp.multiblockTexture(multiblock, "unformed/" + part + "_top"))).texture("down", this.bmp.multiblockTexture(multiblock, "unformed/" + part + "_bottom"))).texture("north", this.bmp.multiblockTexture(multiblock, "unformed/" + part + "_side"))).texture("east", this.bmp.multiblockTexture(multiblock, "unformed/" + part + "_side"))).texture("south", this.bmp.multiblockTexture(multiblock, "unformed/" + part + "_side"))).texture("west", this.bmp.multiblockTexture(multiblock, "unformed/" + part + "_side"));
        return builder;
    }

    public void drainController(Block drainController) {
        Multiblock multiblock = NTMultiblocks.DRAIN.get();
        BlockModelBuilder unformedModel = this.drainControllerModel(drainController, multiblock, false);
        this.bmp.getVariantBuilder(drainController).partialState().with((Property)DrainMultiblock.FORMED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)unformedModel).addModel();
        BlockModelBuilder formedModel = this.drainControllerModel(drainController, multiblock, true);
        this.bmp.getVariantBuilder(drainController).partialState().with((Property)DrainMultiblock.FORMED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)formedModel).addModel();
    }

    @NotNull
    public BlockModelBuilder drainControllerModel(Block drainController, Multiblock multiblock, boolean formed) {
        BlockModelBuilder builder = (BlockModelBuilder)this.bmp.models().withExistingParent(this.bmp.name(drainController) + (formed ? "_formed" : ""), "cube");
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)builder.texture("up", this.bmp.multiblockTexture(multiblock, formed ? "top_4" : "drain_top_unformed"))).texture("down", this.bmp.multiblockTexture(multiblock, formed ? "bottom_4" : "drain_bottom_unformed"))).texture("north", this.bmp.multiblockTexture(multiblock, "drain_side_unformed"))).texture("east", this.bmp.multiblockTexture(multiblock, "drain_side_unformed"))).texture("south", this.bmp.multiblockTexture(multiblock, "drain_side_unformed"))).texture("west", this.bmp.multiblockTexture(multiblock, "drain_side_unformed"));
        return builder;
    }

    public void drainPart(Block drainPartBlock, IntegerRange range) {
        VariantBlockStateBuilder builder = this.bmp.getVariantBuilder(drainPartBlock);
        builder.partialState().with((Property)DrainMultiblock.FORMED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(this.drainPartModel(drainPartBlock, 0, false)).addModel();
        for (int i = ((Integer)range.getMinimum()).intValue(); i <= (Integer)range.getMaximum(); ++i) {
            builder.partialState().with((Property)DrainMultiblock.DRAIN_PART, (Comparable)Integer.valueOf(i)).with((Property)DrainMultiblock.FORMED, (Comparable)Boolean.valueOf(true)).with((Property)DrainPartBlock.LASER_PORT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(this.drainPartModel(drainPartBlock, i, false)).addModel();
            builder.partialState().with((Property)DrainMultiblock.DRAIN_PART, (Comparable)Integer.valueOf(i)).with((Property)DrainMultiblock.FORMED, (Comparable)Boolean.valueOf(true)).with((Property)DrainPartBlock.LASER_PORT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(this.drainPartModel(drainPartBlock, i, true)).addModel();
        }
    }

    public ModelFile drainPartModel(Block drainPartBlock, int index, boolean laserPort) {
        String postfix = laserPort ? "_open" : "";
        BlockModelBuilder builder = (BlockModelBuilder)this.bmp.models().withExistingParent(this.bmp.name(drainPartBlock) + "_" + index + postfix, "cube");
        Multiblock multiblock = NTMultiblocks.DRAIN.get();
        if (index % 2 != 0) {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)builder.texture("up", this.bmp.multiblockTexture(multiblock, "top_" + index))).texture("down", this.bmp.multiblockTexture(multiblock, "bottom_" + index))).texture("north", this.bmp.multiblockTexture(multiblock, "side_1" + postfix))).texture("east", this.bmp.multiblockTexture(multiblock, "side_1" + postfix))).texture("south", this.bmp.multiblockTexture(multiblock, "side_1" + postfix))).texture("west", this.bmp.multiblockTexture(multiblock, "side_1" + postfix));
        } else if (index == 0 || index == 2) {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)builder.texture("up", this.bmp.multiblockTexture(multiblock, "top_" + index))).texture("down", this.bmp.multiblockTexture(multiblock, "bottom_" + index))).texture("north", this.bmp.multiblockTexture(multiblock, "side_" + (2 - index % 3)))).texture("east", this.bmp.multiblockTexture(multiblock, "side_" + index % 3))).texture("south", this.bmp.multiblockTexture(multiblock, "side_" + (2 - index % 3)))).texture("west", this.bmp.multiblockTexture(multiblock, "side_" + index % 3));
        } else {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)builder.texture("up", this.bmp.multiblockTexture(multiblock, "top_" + index))).texture("down", this.bmp.multiblockTexture(multiblock, "bottom_" + index))).texture("north", this.bmp.multiblockTexture(multiblock, "side_" + index % 3))).texture("east", this.bmp.multiblockTexture(multiblock, "side_" + (2 - index % 3)))).texture("south", this.bmp.multiblockTexture(multiblock, "side_" + index % 3))).texture("west", this.bmp.multiblockTexture(multiblock, "side_" + (2 - index % 3)));
        }
        return builder;
    }

    public void bioReactorPart(Block block) {
        VariantBlockStateBuilder builder = this.bmp.getVariantBuilder(block);
        Iterator iterator = BioReactorMultiblock.BIO_REACTOR_PART.getPossibleValues().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)builder.partialState().with((Property)BioReactorMultiblock.BIO_REACTOR_PART, (Comparable)Integer.valueOf(i)).with((Property)BioReactorMultiblock.FORMED, (Comparable)Boolean.valueOf(true)).with((Property)BioReactorMultiblock.TOP, (Comparable)Boolean.valueOf(true)).with((Property)BioReactorMultiblock.HATCH, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(this.bioReactorPartModel(block, i, true, true)).addModel()).partialState().with((Property)BioReactorMultiblock.BIO_REACTOR_PART, (Comparable)Integer.valueOf(i)).with((Property)BioReactorMultiblock.FORMED, (Comparable)Boolean.valueOf(false)).with((Property)BioReactorMultiblock.TOP, (Comparable)Boolean.valueOf(true)).with((Property)BioReactorMultiblock.HATCH, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(this.bioReactorPartModel(block, i, true, true)).addModel()).partialState().with((Property)BioReactorMultiblock.BIO_REACTOR_PART, (Comparable)Integer.valueOf(i)).with((Property)BioReactorMultiblock.FORMED, (Comparable)Boolean.valueOf(true)).with((Property)BioReactorMultiblock.TOP, (Comparable)Boolean.valueOf(false)).with((Property)BioReactorMultiblock.HATCH, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(this.bioReactorPartModel(block, i, false, true)).addModel()).partialState().with((Property)BioReactorMultiblock.BIO_REACTOR_PART, (Comparable)Integer.valueOf(i)).with((Property)BioReactorMultiblock.FORMED, (Comparable)Boolean.valueOf(false)).with((Property)BioReactorMultiblock.TOP, (Comparable)Boolean.valueOf(false)).with((Property)BioReactorMultiblock.HATCH, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(this.bioReactorPartModel(block, i, false, true)).addModel()).partialState().with((Property)BioReactorMultiblock.BIO_REACTOR_PART, (Comparable)Integer.valueOf(i)).with((Property)BioReactorMultiblock.FORMED, (Comparable)Boolean.valueOf(true)).with((Property)BioReactorMultiblock.TOP, (Comparable)Boolean.valueOf(true)).with((Property)BioReactorMultiblock.HATCH, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(this.bioReactorPartModel(block, i, true, false)).addModel()).partialState().with((Property)BioReactorMultiblock.BIO_REACTOR_PART, (Comparable)Integer.valueOf(i)).with((Property)BioReactorMultiblock.FORMED, (Comparable)Boolean.valueOf(false)).with((Property)BioReactorMultiblock.TOP, (Comparable)Boolean.valueOf(true)).with((Property)BioReactorMultiblock.HATCH, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(this.bioReactorPartModel(block, i, true, false)).addModel()).partialState().with((Property)BioReactorMultiblock.BIO_REACTOR_PART, (Comparable)Integer.valueOf(i)).with((Property)BioReactorMultiblock.FORMED, (Comparable)Boolean.valueOf(true)).with((Property)BioReactorMultiblock.TOP, (Comparable)Boolean.valueOf(false)).with((Property)BioReactorMultiblock.HATCH, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(this.bioReactorPartModel(block, i, false, false)).addModel()).partialState().with((Property)BioReactorMultiblock.BIO_REACTOR_PART, (Comparable)Integer.valueOf(i)).with((Property)BioReactorMultiblock.FORMED, (Comparable)Boolean.valueOf(false)).with((Property)BioReactorMultiblock.TOP, (Comparable)Boolean.valueOf(false)).with((Property)BioReactorMultiblock.HATCH, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(this.bioReactorPartModel(block, i, false, false)).addModel();
        }
    }

    private ModelFile bioReactorPartModel(Block block, int index, boolean top, boolean hatch) {
        Multiblock multiblock = NTMultiblocks.BIO_REACTOR.get();
        String middleFix = top ? "top" : "bottom";
        BlockModelBuilder builder = (BlockModelBuilder)this.bmp.models().withExistingParent(this.bmp.name(block) + "_" + index + "_" + middleFix + (hatch ? "_hatch" : ""), "cube");
        if (index % 2 != 0) {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)builder.texture("up", hatch ? this.bmp.multiblockTexture(multiblock, "top_" + index + "_hatch") : this.bmp.multiblockTexture(multiblock, "top_" + index))).texture("down", this.bmp.blockTexture((Block)NTBlocks.POLISHED_PRISMARINE.get()))).texture("north", this.bmp.multiblockTexture(multiblock, "side_" + middleFix + "_1"))).texture("east", this.bmp.multiblockTexture(multiblock, "side_" + middleFix + "_1"))).texture("south", this.bmp.multiblockTexture(multiblock, "side_" + middleFix + "_1"))).texture("west", this.bmp.multiblockTexture(multiblock, "side_" + middleFix + "_1"));
        } else if (index == 0 || index == 2) {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)builder.texture("up", this.bmp.multiblockTexture(multiblock, "top_" + index))).texture("down", this.bmp.blockTexture((Block)NTBlocks.POLISHED_PRISMARINE.get()))).texture("north", this.bmp.multiblockTexture(multiblock, "side_" + middleFix + "_" + (2 - index % 3)))).texture("east", this.bmp.multiblockTexture(multiblock, "side_" + middleFix + "_" + index % 3))).texture("south", this.bmp.multiblockTexture(multiblock, "side_" + middleFix + "_" + (2 - index % 3)))).texture("west", this.bmp.multiblockTexture(multiblock, "side_" + middleFix + "_" + index % 3));
        } else {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)builder.texture("up", this.bmp.multiblockTexture(multiblock, "top_" + index))).texture("down", this.bmp.blockTexture((Block)NTBlocks.POLISHED_PRISMARINE.get()))).texture("north", this.bmp.multiblockTexture(multiblock, "side_" + middleFix + "_" + index % 3))).texture("east", this.bmp.multiblockTexture(multiblock, "side_" + middleFix + "_" + (2 - index % 3)))).texture("south", this.bmp.multiblockTexture(multiblock, "side_" + middleFix + "_" + index % 3))).texture("west", this.bmp.multiblockTexture(multiblock, "side_" + middleFix + "_" + (2 - index % 3)));
        }
        return builder;
    }
}

