/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.data;

import com.mojang.serialization.Codec;
import com.portingdeadmods.nautec.data.components.ComponentBacteriaStorage;
import com.portingdeadmods.nautec.data.components.ComponentPowerStorage;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class NTDataComponents {
    public static final DeferredRegister.DataComponents DATA_COMPONENT_TYPES = DeferredRegister.createDataComponents((String)"nautec");
    public static final Supplier<DataComponentType<ComponentPowerStorage>> POWER = NTDataComponents.registerDataComponentType("power", () -> builder -> builder.persistent(ComponentPowerStorage.CODEC).networkSynchronized(ComponentPowerStorage.STREAM_CODEC));
    public static final Supplier<DataComponentType<SimpleFluidContent>> FLUID = NTDataComponents.registerDataComponentType("fluid", () -> builder -> builder.persistent(SimpleFluidContent.CODEC).networkSynchronized(SimpleFluidContent.STREAM_CODEC));
    public static final Supplier<DataComponentType<ComponentBacteriaStorage>> BACTERIA = NTDataComponents.registerDataComponentType("bacteria", () -> builder -> builder.persistent(ComponentBacteriaStorage.CODEC).networkSynchronized(ComponentBacteriaStorage.STREAM_CODEC));
    public static final Supplier<DataComponentType<Boolean>> ABILITY_ENABLED = NTDataComponents.registerDataComponentType("ability_enabled", () -> builder -> builder.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
    public static final Supplier<DataComponentType<Boolean>> IS_INFUSED = NTDataComponents.registerDataComponentType("is_infused", () -> builder -> builder.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
    public static final Supplier<DataComponentType<Integer>> OXYGEN = NTDataComponents.registerDataComponentType("oxygen", () -> builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT));

    public static <T> Supplier<DataComponentType<T>> registerDataComponentType(String name, Supplier<UnaryOperator<DataComponentType.Builder<T>>> builderOperator) {
        return DATA_COMPONENT_TYPES.register(name, () -> ((DataComponentType.Builder)((UnaryOperator)builderOperator.get()).apply(DataComponentType.builder())).build());
    }
}

