/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.items.tools;

import com.portingdeadmods.nautec.api.items.IPowerItem;
import com.portingdeadmods.nautec.capabilities.NTCapabilities;
import com.portingdeadmods.nautec.capabilities.power.IPowerStorage;
import com.portingdeadmods.nautec.content.items.tiers.NTToolMaterials;
import com.portingdeadmods.nautec.data.NTDataComponents;
import com.portingdeadmods.nautec.data.NTDataComponentsUtils;
import com.portingdeadmods.nautec.data.components.ComponentPowerStorage;
import com.portingdeadmods.nautec.utils.ItemUtils;
import com.portingdeadmods.nautec.utils.Tooltips;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class AquarinePickaxeItem
extends PickaxeItem
implements IPowerItem {
    private static final int POWER_PER_BLOCK = 2;

    public AquarinePickaxeItem() {
        super(NTToolMaterials.AQUARINE, new Item.Properties().stacksTo(1).component(NTDataComponents.IS_INFUSED, (Object)false).component(NTDataComponents.ABILITY_ENABLED, (Object)false).component(NTDataComponents.POWER, (Object)ComponentPowerStorage.withCapacity(1200)).attributes(PickaxeItem.createAttributes((Tier)NTToolMaterials.AQUARINE, (float)1.5f, (float)-3.0f)));
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        IPowerStorage powerStorage = (IPowerStorage)stack.getCapability(NTCapabilities.PowerStorage.ITEM);
        if (powerStorage.getPowerStored() <= 0) {
            return InteractionResult.FAIL;
        }
        return super.useOn(context);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        if (miningEntity instanceof Player) {
            Player player = (Player)miningEntity;
            IPowerStorage powerStorage = (IPowerStorage)miningEntity.getItemInHand(InteractionHand.MAIN_HAND).getCapability(NTCapabilities.PowerStorage.ITEM);
            powerStorage.tryDrainPower(1, false);
            BlockHitResult hitResult = (BlockHitResult)player.pick(20.0, 0.0f, false);
            Direction hitFace = hitResult.getDirection();
            if (NTDataComponentsUtils.isAbilityEnabled(stack).booleanValue()) {
                this.mine3x3(level, pos, player, stack, hitFace);
                return true;
            }
        }
        return super.mineBlock(stack, level, state, pos, miningEntity);
    }

    private void mine3x3(Level level, BlockPos pos, Player player, ItemStack stack, Direction hitFace) {
        IPowerStorage powerStorage = (IPowerStorage)stack.getCapability(NTCapabilities.PowerStorage.ITEM);
        if (powerStorage.getPowerStored() > 0) {
            int blocksToBreak = powerStorage.getPowerStored() / 2;
            Iterable<BlockPos> blocksToMine = this.get3x3MiningArea(pos, hitFace);
            for (BlockPos targetPos : blocksToMine) {
                if (blocksToBreak <= 0 || !this.canMine(level, targetPos, level.getBlockState(targetPos))) continue;
                blocksToBreak = this.breakBlock(level, targetPos, stack, player, powerStorage, blocksToBreak);
            }
        }
    }

    private Iterable<BlockPos> get3x3MiningArea(BlockPos center, Direction hitFace) {
        return switch (hitFace) {
            case Direction.NORTH, Direction.SOUTH -> BlockPos.betweenClosed((BlockPos)center.offset(-1, -1, 0), (BlockPos)center.offset(1, 1, 0));
            case Direction.EAST, Direction.WEST -> BlockPos.betweenClosed((BlockPos)center.offset(0, -1, -1), (BlockPos)center.offset(0, 1, 1));
            default -> BlockPos.betweenClosed((BlockPos)center.offset(-1, 0, -1), (BlockPos)center.offset(1, 0, 1));
        };
    }

    private boolean canMine(Level level, BlockPos pos, BlockState state) {
        return state.is(BlockTags.MINEABLE_WITH_PICKAXE) && level.getBlockEntity(pos) == null;
    }

    private int breakBlock(Level level, BlockPos pos, ItemStack stack, Player player, IPowerStorage powerStorage, int blocksToBreak) {
        BlockState state = level.getBlockState(pos);
        if (!this.canMine(level, pos, state) || blocksToBreak <= 0 || powerStorage.getPowerStored() < 2) {
            return blocksToBreak;
        }
        level.destroyBlock(pos, true);
        powerStorage.tryDrainPower(2, false);
        return --blocksToBreak;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        IPowerStorage powerStorage = (IPowerStorage)attacker.getItemInHand(InteractionHand.MAIN_HAND).getCapability(NTCapabilities.PowerStorage.ITEM);
        powerStorage.tryDrainPower(1, false);
        return super.hurtEnemy(stack, target, attacker);
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return ItemUtils.POWER_BAR_COLOR;
    }

    public int getBarWidth(ItemStack stack) {
        return ItemUtils.powerForDurabilityBar(stack);
    }

    @Override
    public int getMaxInput() {
        return 128;
    }

    @Override
    public int getMaxOutput() {
        return 100;
    }

    public boolean isFoil(ItemStack stack) {
        return NTDataComponentsUtils.isAbilityEnabled(stack) != false || stack.isEnchanted();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        IPowerStorage powerStorage = (IPowerStorage)stack.getCapability(NTCapabilities.PowerStorage.ITEM);
        Tooltips.trans(tooltipComponents, "nautec.tool.pickaxe.ability", ChatFormatting.DARK_PURPLE);
        if (!NTDataComponentsUtils.isInfused(stack).booleanValue()) {
            Tooltips.trans(tooltipComponents, "nautec.tool.infuse-me", ChatFormatting.DARK_GREEN);
        } else {
            Tooltips.transtrans(tooltipComponents, "nautec.tool.status", NTDataComponentsUtils.isAbilityEnabled(stack) != false ? "nautec.tool.enabled" : "nautec.tool.disabled", NTDataComponentsUtils.isAbilityEnabled(stack) != false ? ChatFormatting.GREEN : ChatFormatting.RED);
        }
        Tooltips.transInsert(tooltipComponents, "nautec.tool.power", powerStorage.getPowerStored() + "/" + powerStorage.getPowerCapacity(), ChatFormatting.DARK_AQUA);
    }
}

