/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.items;

import com.portingdeadmods.nautec.api.items.IPowerItem;
import com.portingdeadmods.nautec.capabilities.NTCapabilities;
import com.portingdeadmods.nautec.capabilities.power.IPowerStorage;
import com.portingdeadmods.nautec.content.items.tiers.NTArmorMaterials;
import com.portingdeadmods.nautec.data.NTDataComponents;
import com.portingdeadmods.nautec.data.components.ComponentPowerStorage;
import com.portingdeadmods.nautec.utils.ItemUtils;
import com.portingdeadmods.nautec.utils.Tooltips;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.Nullable;

public class AquarineArmorItem
extends ArmorItem
implements IPowerItem {
    public static final AttributeModifier ENABLED_ARMOR_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"armor"), 10.0, AttributeModifier.Operation.ADD_VALUE);
    public static final AttributeModifier DISABLED_ARMOR_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"armor"), 0.0, AttributeModifier.Operation.ADD_VALUE);
    public static final AttributeModifier ENABLED_TOUGHNESS_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"toughness"), 5.0, AttributeModifier.Operation.ADD_VALUE);
    public static final AttributeModifier DISABLED_TOUGHNESS_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"toughness"), 0.0, AttributeModifier.Operation.ADD_VALUE);

    public AquarineArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(NTArmorMaterials.AQUARINE_STEEL, type, properties.durability(100).component(NTDataComponents.POWER, (Object)ComponentPowerStorage.withCapacity(512)));
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        IPowerStorage powerStorage = (IPowerStorage)stack.getCapability(NTCapabilities.PowerStorage.ITEM);
        ItemAttributeModifiers attributes = (ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        boolean hasEnergy = powerStorage.getPowerStored() > 0;
        EquipmentSlot slotType = this.getEquipmentSlot();
        attributes = attributes.withModifierAdded(Attributes.ARMOR, hasEnergy ? ENABLED_ARMOR_MODIFIER : DISABLED_ARMOR_MODIFIER, EquipmentSlotGroup.bySlot((EquipmentSlot)slotType));
        attributes = attributes.withModifierAdded(Attributes.ARMOR_TOUGHNESS, hasEnergy ? ENABLED_TOUGHNESS_MODIFIER : DISABLED_TOUGHNESS_MODIFIER, EquipmentSlotGroup.bySlot((EquipmentSlot)slotType));
        return attributes;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        Item item = stack.getItem();
        if (item instanceof IPowerItem) {
            IPowerItem poweredTool = (IPowerItem)item;
            IPowerStorage energyStorage = (IPowerStorage)stack.getCapability(NTCapabilities.PowerStorage.ITEM);
            if (energyStorage == null) {
                return amount;
            }
            double reductionFactor = 0.0;
            if (entity != null) {
                HolderLookup.RegistryLookup registrylookup = entity.level().getServer().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
                int unbreakingLevel = stack.getEnchantmentLevel((Holder)registrylookup.getOrThrow(Enchantments.UNBREAKING));
                reductionFactor = Math.min(4.0, (double)unbreakingLevel * 0.1);
            }
            int finalEnergyCost = (int)Math.max(0.0, (double)amount - (double)amount * reductionFactor);
            energyStorage.tryDrainPower(finalEnergyCost, false);
            return 0;
        }
        return amount;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return ItemUtils.POWER_BAR_COLOR;
    }

    public int getBarWidth(ItemStack stack) {
        return ItemUtils.powerForDurabilityBar(stack);
    }

    @Override
    public int getMaxInput() {
        return 128;
    }

    @Override
    public int getMaxOutput() {
        return 100;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        IPowerStorage powerStorage = (IPowerStorage)stack.getCapability(NTCapabilities.PowerStorage.ITEM);
        Tooltips.trans(tooltipComponents, "nautec.armor.ability.desc", ChatFormatting.DARK_PURPLE);
        Tooltips.transInsert(tooltipComponents, "nautec.armor.power", powerStorage.getPowerStored() + "/" + powerStorage.getPowerCapacity(), ChatFormatting.DARK_AQUA);
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

