/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.portingdeadmods.nautec.api.augments.Augment;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import com.portingdeadmods.nautec.api.augments.AugmentType;
import com.portingdeadmods.nautec.content.commands.arguments.AugmentSlotArgumentType;
import com.portingdeadmods.nautec.content.commands.arguments.AugmentTypeArgumentType;
import com.portingdeadmods.nautec.network.SyncAugmentPayload;
import com.portingdeadmods.nautec.utils.AugmentHelper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public class SetAugmentCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder nautecCommand = (LiteralArgumentBuilder)Commands.literal((String)"nautec").requires(player -> player.hasPermission(2));
        dispatcher.register((LiteralArgumentBuilder)nautecCommand.then(Commands.literal((String)"augments").then(Commands.literal((String)"set").then(Commands.argument((String)"slot", (ArgumentType)AugmentSlotArgumentType.getInstance()).then(Commands.argument((String)"augment", (ArgumentType)AugmentTypeArgumentType.getInstance()).executes(SetAugmentCommand::execute))))));
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) {
        AugmentSlot slot;
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayer();
        Augment currentAug = AugmentHelper.getAugmentBySlot((Player)player, slot = (AugmentSlot)ctx.getArgument("slot", AugmentSlot.class));
        if (currentAug != null) {
            currentAug.onRemoved((Player)player);
        }
        Augment augment = AugmentHelper.createAugment((AugmentType)ctx.getArgument("augment", AugmentType.class), (Player)player, slot);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncAugmentPayload(augment, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        player.sendSystemMessage((Component)Component.literal((String)("Set augment in slot '" + slot.getName() + "' to: " + String.valueOf(augment.getAugmentType()))));
        return 1;
    }
}

