/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blocks.multiblock.part;

import com.mojang.serialization.MapCodec;
import com.portingdeadmods.nautec.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.nautec.api.blocks.DisplayBlock;
import com.portingdeadmods.nautec.api.blocks.blockentities.LaserBlock;
import com.portingdeadmods.nautec.api.multiblocks.Multiblock;
import com.portingdeadmods.nautec.content.blockentities.multiblock.part.DrainPartBlockEntity;
import com.portingdeadmods.nautec.content.items.tools.AquarineWrenchItem;
import com.portingdeadmods.nautec.content.multiblocks.DrainMultiblock;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import com.portingdeadmods.nautec.registries.NTMultiblocks;
import com.portingdeadmods.nautec.utils.BlockUtils;
import com.portingdeadmods.nautec.utils.MultiblockHelper;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.enums.BubbleColumnDirection;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class DrainPartBlock
extends LaserBlock
implements DisplayBlock {
    public static final VoxelShape[] SHAPES;
    public static final BooleanProperty LASER_PORT;
    public static final BooleanProperty OPEN;
    public static final BooleanProperty HAS_POWER;

    public DrainPartBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LASER_PORT, (Comparable)Boolean.valueOf(false))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_POWER, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean waterloggable() {
        return false;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{DrainMultiblock.DRAIN_PART, Multiblock.FORMED, LASER_PORT, OPEN, HAS_POWER}));
    }

    @Override
    @NotNull
    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && ((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            level.scheduleTick(currentPos, (Block)this, 20);
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    @Override
    public BlockEntityType<? extends ContainerBlockEntity> getBlockEntityType() {
        return NTBlockEntityTypes.DRAIN_PART.get();
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return DrainPartBlock.simpleCodec(DrainPartBlock::new);
    }

    @Override
    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult p_60508_) {
        BlockEntity blockEntity;
        if (player.isShiftKeyDown() && (Integer)state.getValue((Property)DrainMultiblock.DRAIN_PART) == 4 && !((Boolean)state.getValue((Property)OPEN)).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof DrainPartBlockEntity) {
            DrainPartBlockEntity drainPartBlockEntity = (DrainPartBlockEntity)blockEntity;
            drainPartBlockEntity.open();
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, p_60508_);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() instanceof AquarineWrenchItem && !((Boolean)state.getValue((Property)LASER_PORT)).booleanValue() && (Integer)state.getValue((Property)DrainMultiblock.DRAIN_PART) % 2 != 0) {
            DrainPartBlock.setLaserPort(pos, level, hitResult.getDirection());
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public static void setLaserPort(BlockPos partPos, Level level, Direction direction) {
        BlockEntity blockEntity = level.getBlockEntity(partPos);
        if (blockEntity instanceof DrainPartBlockEntity) {
            BlockPos[] blocks;
            DrainPartBlockEntity drainPartBlockEntity = (DrainPartBlockEntity)blockEntity;
            BlockPos controllerPos = drainPartBlockEntity.getActualBlockEntityPos();
            for (BlockPos pos : blocks = BlockUtils.getBlocksAroundSelfHorizontal(controllerPos)) {
                BlockEntity blockEntity2 = level.getBlockEntity(pos);
                if (!(blockEntity2 instanceof DrainPartBlockEntity)) continue;
                DrainPartBlockEntity drainPartBlockEntity1 = (DrainPartBlockEntity)blockEntity2;
                drainPartBlockEntity1.setLaserPort(null);
                level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)LASER_PORT, (Comparable)Boolean.valueOf(false)));
            }
            drainPartBlockEntity.setLaserPort(direction);
            if (!level.isClientSide()) {
                level.setBlockAndUpdate(partPos, (BlockState)level.getBlockState(partPos).setValue((Property)LASER_PORT, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue() && ((Boolean)state.getValue((Property)HAS_POWER)).booleanValue()) {
            entity.hurt(level.damageSources().drown(), 4.0f);
        }
    }

    @NotNull
    public BubbleColumnDirection getBubbleColumnDirection(BlockState state) {
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue() && ((Boolean)state.getValue((Property)HAS_POWER)).booleanValue() && ((Integer)state.getValue((Property)DrainMultiblock.DRAIN_PART) == 4 || (Integer)state.getValue((Property)DrainMultiblock.DRAIN_PART) % 2 != 0)) {
            return BubbleColumnDirection.DOWNWARD;
        }
        return super.getBubbleColumnDirection(state);
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            DrainPartBlockEntity partBE = (DrainPartBlockEntity)level.getBlockEntity(pos);
            BlockPos actualBlockEntityPos = partBE.getActualBlockEntityPos();
            MultiblockHelper.unform(NTMultiblocks.DRAIN.get(), actualBlockEntityPos, level, null);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Override
    public List<Component> displayText(Level level, BlockPos blockPos, Player player) {
        Component first;
        DrainPartBlockEntity drainPartBlockEntity;
        BlockPos blockEntityPos;
        IFluidHandler fluidHandler;
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof DrainPartBlockEntity && (fluidHandler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, blockEntityPos = (drainPartBlockEntity = (DrainPartBlockEntity)blockEntity).getActualBlockEntityPos(), level.getBlockState(blockEntityPos), level.getBlockEntity(blockEntityPos), null)) != null && (first = super.displayText(level, blockPos, player).getFirst()) != null) {
            return List.of(first, Component.literal((String)("Fluid Stored: " + fluidHandler.getFluidInTank(0).getAmount())).withStyle(ChatFormatting.WHITE));
        }
        return List.of();
    }

    static {
        LASER_PORT = BooleanProperty.create((String)"laser_port");
        OPEN = BooleanProperty.create((String)"open");
        HAS_POWER = BooleanProperty.create((String)"enough_power");
        SHAPES = new VoxelShape[]{Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape)Block.box((double)12.0, (double)3.0, (double)12.0, (double)16.0, (double)5.0, (double)16.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)3.0, (double)12.0, (double)16.0, (double)5.0, (double)16.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)3.0, (double)12.0, (double)4.0, (double)5.0, (double)16.0)), Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape)Block.box((double)12.0, (double)3.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0)), Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.box((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0), Block.box((double)1.0, (double)8.75, (double)1.0, (double)15.0, (double)9.25, (double)15.0)).reduce(Shapes::or).get(), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)3.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)3.0, (double)0.0, (double)4.0, (double)5.0, (double)16.0)), Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)14.0), (VoxelShape)Block.box((double)12.0, (double)3.0, (double)0.0, (double)16.0, (double)5.0, (double)4.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)14.0), (VoxelShape)Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)5.0, (double)4.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)3.0, (double)14.0), (VoxelShape)Block.box((double)0.0, (double)3.0, (double)0.0, (double)4.0, (double)5.0, (double)4.0))};
    }
}

