/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blocks;

import com.mojang.serialization.MapCodec;
import com.portingdeadmods.nautec.Nautec;
import com.portingdeadmods.nautec.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.nautec.api.blocks.blockentities.LaserBlock;
import com.portingdeadmods.nautec.api.utils.HorizontalDirection;
import com.portingdeadmods.nautec.content.blockentities.MixerBlockEntity;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import com.portingdeadmods.nautec.utils.ItemUtils;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class MixerBlock
extends LaserBlock {
    public static final VoxelShape SHAPE = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0), Block.box((double)14.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0), Block.box((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0), Block.box((double)9.0, (double)14.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0), Block.box((double)0.0, (double)14.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0), Block.box((double)7.0, (double)14.0, (double)10.0, (double)9.0, (double)16.0, (double)16.0), Block.box((double)7.0, (double)14.0, (double)0.0, (double)9.0, (double)16.0, (double)6.0), Block.box((double)6.0, (double)14.0, (double)9.0, (double)10.0, (double)16.0, (double)10.0), Block.box((double)6.0, (double)14.0, (double)6.0, (double)10.0, (double)16.0, (double)7.0)).reduce(Shapes::or).get();

    public MixerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public boolean waterloggable() {
        return true;
    }

    @Override
    public BlockEntityType<? extends ContainerBlockEntity> getBlockEntityType() {
        return NTBlockEntityTypes.MIXER.get();
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return MixerBlock.simpleCodec(MixerBlock::new);
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING}));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MixerBlockEntity) {
            MixerBlockEntity mixerBE = (MixerBlockEntity)blockEntity;
            IFluidHandler fluidHandler = mixerBE.getFluidHandler();
            if (stack.getCapability(Capabilities.FluidHandler.ITEM) != null) {
                IFluidHandler itemFluidHandler = (IFluidHandler)stack.getCapability(Capabilities.FluidHandler.ITEM);
                IFluidHandler iFluidHandler = mixerBE.getFluidHandler();
                if (iFluidHandler instanceof FluidTank) {
                    FluidTank fluidTank = (FluidTank)iFluidHandler;
                    iFluidHandler = mixerBE.getSecondaryFluidHandler();
                    if (iFluidHandler instanceof FluidTank) {
                        FluidTank secFluidTank = (FluidTank)iFluidHandler;
                        if (itemFluidHandler.getFluidInTank(0).isEmpty()) {
                            MixerBlock.extractFluid(player, level, hand, fluidTank, secFluidTank, itemFluidHandler);
                        } else {
                            MixerBlock.insertFluid(player, level, hand, fluidHandler, itemFluidHandler);
                        }
                        return ItemInteractionResult.SUCCESS;
                    }
                }
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    private static void insertFluid(Player player, Level level, InteractionHand interactionHand, IFluidHandler fluidHandler, IFluidHandler fluidHandlerItem) {
        int filled = fluidHandler.fill(fluidHandlerItem.getFluidInTank(0).copy(), IFluidHandler.FluidAction.EXECUTE);
        FluidStack drained = fluidHandlerItem.drain(filled, IFluidHandler.FluidAction.EXECUTE);
        Item item = player.getItemInHand(interactionHand).getItem();
        if (item instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)item;
            if (!drained.isEmpty() && drained.getAmount() >= 1000) {
                player.getItemInHand(interactionHand).shrink(1);
                ItemUtils.giveItemToPlayerNoSound(player, Items.BUCKET.getDefaultInstance());
                if (bucketItem.content.isSame((Fluid)Fluids.WATER)) {
                    level.playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), SoundEvents.BUCKET_EMPTY, SoundSource.PLAYERS, 0.8f, 1.0f);
                } else if (bucketItem.content.isSame((Fluid)Fluids.LAVA)) {
                    level.playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), SoundEvents.BUCKET_EMPTY_LAVA, SoundSource.PLAYERS, 0.8f, 1.0f);
                }
            }
        }
    }

    private static void extractFluid(Player player, Level level, InteractionHand interactionHand, FluidTank fluidHandler, FluidTank secondaryFluidHandler, IFluidHandler fluidHandlerItem) {
        FluidTank curHandler = secondaryFluidHandler.getFluidInTank(0).isEmpty() ? fluidHandler : secondaryFluidHandler;
        Nautec.LOGGER.debug("Extracting secondary: {}", (Object)(curHandler == secondaryFluidHandler ? 1 : 0));
        FluidStack fluidInTank = curHandler.getFluidInTank(0);
        if (player.getItemInHand(interactionHand).is(Items.BUCKET)) {
            player.getItemInHand(interactionHand).shrink(1);
            ItemUtils.giveItemToPlayerNoSound(player, fluidInTank.getFluid().getBucket().getDefaultInstance());
            if (fluidInTank.is((Fluid)Fluids.WATER)) {
                level.playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), SoundEvents.BUCKET_FILL, SoundSource.PLAYERS, 0.8f, 1.0f);
            } else if (fluidInTank.is((Fluid)Fluids.LAVA)) {
                level.playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), SoundEvents.BUCKET_FILL_LAVA, SoundSource.PLAYERS, 0.8f, 1.0f);
            }
            curHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        } else {
            FluidStack fluidStack = curHandler.drain(curHandler.getFluidInTank(0).getAmount(), IFluidHandler.FluidAction.EXECUTE);
            int remainderAmount = fluidHandlerItem.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            FluidStack newFluidStack = fluidStack.copy();
            newFluidStack.setAmount(remainderAmount);
            curHandler.setFluid(newFluidStack);
        }
    }

    private ItemInteractionResult insertItemsSided(ItemStack stack, Player player, InteractionHand hand, IItemHandler itemHandler, Direction clickedFace) {
        int slot = HorizontalDirection.fromRegularDirection(clickedFace).ordinal();
        ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
        if (MixerBlock.canInsert(stack, itemHandler, stackInSlot, slot)) {
            ItemStack itemStack = itemHandler.insertItem(slot, stack, false);
            player.setItemInHand(hand, itemStack);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private ItemInteractionResult extractItemsSided(Player player, IItemHandler itemHandler, Direction clickedFace) {
        ItemStack stackInSlot;
        int slot = HorizontalDirection.fromRegularDirection(clickedFace).ordinal();
        ItemStack itemStack = itemHandler.extractItem(slot, (stackInSlot = itemHandler.getStackInSlot(slot)).getMaxStackSize(), false);
        if (!itemStack.isEmpty()) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)itemStack);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private static boolean canInsert(ItemStack stack, IItemHandler itemHandler, ItemStack stackInSlot, int slot) {
        return stackInSlot.isEmpty() || stackInSlot.is(stack.getItem()) && stack.getCount() + stackInSlot.getCount() <= Math.min(itemHandler.getSlotLimit(slot), stack.getMaxStackSize());
    }
}

