/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blocks;

import com.mojang.serialization.MapCodec;
import com.portingdeadmods.nautec.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.nautec.api.blocks.blockentities.LaserBlock;
import com.portingdeadmods.nautec.content.blocks.BacterialAnalyzerTopBlock;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import com.portingdeadmods.nautec.registries.NTBlocks;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BacterialAnalyzerBlock
extends LaserBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final VoxelShape SHAPE = Stream.of(Block.box((double)2.0, (double)0.0, (double)9.0, (double)7.0, (double)13.0, (double)14.0), Block.box((double)9.0, (double)0.0, (double)9.0, (double)14.0, (double)13.0, (double)14.0), Block.box((double)9.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)7.0), Block.box((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)7.0, (double)13.0, (double)7.0), Block.box((double)7.0, (double)0.0, (double)4.0, (double)9.0, (double)13.0, (double)12.0), Block.box((double)9.0, (double)0.0, (double)7.0, (double)12.0, (double)13.0, (double)9.0), Block.box((double)4.0, (double)0.0, (double)7.0, (double)7.0, (double)13.0, (double)9.0)).reduce(Shapes::or).get();

    public BacterialAnalyzerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public boolean waterloggable() {
        return true;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{FACING}));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (context.getLevel().getBlockState(context.getClickedPos().above()).canBeReplaced()) {
            return state != null ? (BlockState)state.setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite()) : null;
        }
        return null;
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (!state.is(oldState.getBlock())) {
            level.setBlockAndUpdate(pos.above(), (BlockState)((BacterialAnalyzerTopBlock)((Object)NTBlocks.BACTERIAL_ANALYZER_TOP.get())).defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))));
        }
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        if (!state.is(newState.getBlock())) {
            level.removeBlock(pos.above(), false);
        }
    }

    @Override
    public BlockEntityType<? extends ContainerBlockEntity> getBlockEntityType() {
        return NTBlockEntityTypes.BACTERIAL_ANALYZER.get();
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return BacterialAnalyzerBlock.simpleCodec(BacterialAnalyzerBlock::new);
    }
}

