/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blocks;

import com.portingdeadmods.nautec.capabilities.NTCapabilities;
import com.portingdeadmods.nautec.utils.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BacteriaPipeBlock
extends Block {
    public static final BooleanProperty[] CONNECTION = new BooleanProperty[6];
    public final int border;
    public final VoxelShape shapeCenter;
    public final VoxelShape shapeD;
    public final VoxelShape shapeU;
    public final VoxelShape shapeN;
    public final VoxelShape shapeS;
    public final VoxelShape shapeW;
    public final VoxelShape shapeE;
    public final VoxelShape[] shapes;

    public BacteriaPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        int width = 4;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)CONNECTION[0], (Comparable)Boolean.valueOf(false))).setValue((Property)CONNECTION[1], (Comparable)Boolean.valueOf(false))).setValue((Property)CONNECTION[2], (Comparable)Boolean.valueOf(false))).setValue((Property)CONNECTION[3], (Comparable)Boolean.valueOf(false))).setValue((Property)CONNECTION[4], (Comparable)Boolean.valueOf(false))).setValue((Property)CONNECTION[5], (Comparable)Boolean.valueOf(false)));
        int B0 = this.border = (16 - width) / 2;
        int B1 = 16 - this.border;
        this.shapeCenter = BacteriaPipeBlock.box((double)B0, (double)B0, (double)B0, (double)B1, (double)B1, (double)B1);
        this.shapeD = BacteriaPipeBlock.box((double)B0, (double)0.0, (double)B0, (double)B1, (double)B0, (double)B1);
        this.shapeU = BacteriaPipeBlock.box((double)B0, (double)B1, (double)B0, (double)B1, (double)16.0, (double)B1);
        this.shapeN = BacteriaPipeBlock.box((double)B0, (double)B0, (double)0.0, (double)B1, (double)B1, (double)B0);
        this.shapeS = BacteriaPipeBlock.box((double)B0, (double)B0, (double)B1, (double)B1, (double)B1, (double)16.0);
        this.shapeW = BacteriaPipeBlock.box((double)0.0, (double)B0, (double)B0, (double)B0, (double)B1, (double)B1);
        this.shapeE = BacteriaPipeBlock.box((double)B1, (double)B0, (double)B0, (double)16.0, (double)B1, (double)B1);
        this.shapes = new VoxelShape[64];
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        int index = 0;
        for (Direction direction : Direction.values()) {
            if (!((Boolean)blockState.getValue((Property)CONNECTION[direction.ordinal()])).booleanValue()) continue;
            index |= 1 << direction.ordinal();
        }
        return this.getShape(index);
    }

    public VoxelShape getShape(int i) {
        if (this.shapes[i] == null) {
            this.shapes[i] = this.shapeCenter;
            if ((i >> 0 & 1) != 0) {
                this.shapes[i] = Shapes.or((VoxelShape)this.shapes[i], (VoxelShape)this.shapeD);
            }
            if ((i >> 1 & 1) != 0) {
                this.shapes[i] = Shapes.or((VoxelShape)this.shapes[i], (VoxelShape)this.shapeU);
            }
            if ((i >> 2 & 1) != 0) {
                this.shapes[i] = Shapes.or((VoxelShape)this.shapes[i], (VoxelShape)this.shapeN);
            }
            if ((i >> 3 & 1) != 0) {
                this.shapes[i] = Shapes.or((VoxelShape)this.shapes[i], (VoxelShape)this.shapeS);
            }
            if ((i >> 4 & 1) != 0) {
                this.shapes[i] = Shapes.or((VoxelShape)this.shapes[i], (VoxelShape)this.shapeW);
            }
            if ((i >> 5 & 1) != 0) {
                this.shapes[i] = Shapes.or((VoxelShape)this.shapes[i], (VoxelShape)this.shapeE);
            }
        }
        return this.shapes[i];
    }

    @NotNull
    public BlockState updateShape(BlockState blockState, Direction facingDirection, BlockState facingBlockState, LevelAccessor level, BlockPos blockPos, BlockPos facingBlockPos) {
        int connectionIndex = facingDirection.ordinal();
        BlockEntity blockEntity = level.getBlockEntity(facingBlockPos);
        if (this.canConnectToPipe(facingBlockState) || blockEntity != null && this.canConnectTo(blockEntity)) {
            return (BlockState)blockState.setValue((Property)CONNECTION[connectionIndex], (Comparable)Boolean.valueOf(true));
        }
        if (facingBlockState.isEmpty()) {
            return (BlockState)blockState.setValue((Property)CONNECTION[connectionIndex], (Comparable)Boolean.valueOf(false));
        }
        return blockState;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockState blockState = this.defaultBlockState();
        for (Direction direction : Direction.values()) {
            int connectionIndex = direction.ordinal();
            BlockPos facingBlockPos = blockPos.relative(direction);
            BlockEntity blockEntity = level.getBlockEntity(facingBlockPos);
            if (blockEntity == null || !this.canConnectTo(blockEntity)) continue;
            blockState = (BlockState)blockState.setValue((Property)CONNECTION[connectionIndex], (Comparable)Boolean.valueOf(true));
        }
        return blockState;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CONNECTION[0], CONNECTION[1], CONNECTION[2], CONNECTION[3], CONNECTION[4], CONNECTION[5]});
    }

    public boolean canConnectToPipe(BlockState connectTo) {
        return connectTo.is((Block)this);
    }

    public boolean canConnectTo(@Nullable BlockEntity connectTo) {
        return connectTo != null && BlockUtils.blockEntityCapability(NTCapabilities.BacteriaStorage.BLOCK, connectTo) != null;
    }

    static {
        for (Direction dir : Direction.values()) {
            BacteriaPipeBlock.CONNECTION[dir.get3DDataValue()] = BooleanProperty.create((String)dir.getSerializedName());
        }
    }
}

