/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blocks;

import com.mojang.serialization.MapCodec;
import com.portingdeadmods.nautec.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.nautec.api.blocks.DisplayBlock;
import com.portingdeadmods.nautec.api.blocks.blockentities.LaserBlock;
import com.portingdeadmods.nautec.content.blockentities.AquaticCatalystBlockEntity;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class AquaticCatalystBlock
extends LaserBlock
implements DisplayBlock {
    public static final IntegerProperty STAGE = IntegerProperty.create((String)"stage", (int)0, (int)8);

    public AquaticCatalystBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH)).setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public boolean waterloggable() {
        return false;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return AquaticCatalystBlock.simpleCodec(AquaticCatalystBlock::new);
    }

    @Override
    public BlockEntityType<? extends ContainerBlockEntity> getBlockEntityType() {
        return NTBlockEntityTypes.AQUATIC_CATALYST.get();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{BlockStateProperties.FACING, STAGE}));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        return state != null ? (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)context.getNearestLookingDirection().getOpposite()) : null;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        AquaticCatalystBlockEntity be = (AquaticCatalystBlockEntity)level.getBlockEntity(pos);
        IItemHandler itemHandler = be.getItemHandler();
        if (!stack.isEmpty()) {
            boolean valid = itemHandler.isItemValid(0, stack);
            if (valid) {
                ItemStack remainder = itemHandler.insertItem(0, stack, false);
                player.setItemInHand(hand, remainder);
                return ItemInteractionResult.SUCCESS;
            }
        } else {
            ItemStack extracted = itemHandler.extractItem(0, itemHandler.getSlotLimit(0), false);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)extracted, (int)player.getInventory().selected);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public List<Component> displayText(Level level, BlockPos blockPos, Player player) {
        BlockState blockState = level.getBlockState(blockPos);
        AquaticCatalystBlockEntity be = (AquaticCatalystBlockEntity)level.getBlockEntity(blockPos);
        return List.of(Component.literal((String)("Duration: " + be.getDuration())).withStyle(ChatFormatting.WHITE));
    }
}

