/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities.multiblock.controller;

import com.portingdeadmods.nautec.api.bacteria.Bacteria;
import com.portingdeadmods.nautec.api.bacteria.BacteriaInstance;
import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.api.blockentities.multiblock.MultiblockEntity;
import com.portingdeadmods.nautec.api.multiblocks.MultiblockData;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.capabilities.bacteria.IBacteriaStorage;
import com.portingdeadmods.nautec.content.menus.BioReactorMenu;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import com.portingdeadmods.nautec.utils.BacteriaHelper;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BioReactorBlockEntity
extends LaserBlockEntity
implements MenuProvider,
MultiblockEntity {
    private MultiblockData multiblockData;
    private final int[] progress;

    public BioReactorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.BIO_REACTOR.get(), blockPos, blockState);
        this.addItemHandler(3);
        this.addBacteriaStorage(3);
        this.multiblockData = MultiblockData.EMPTY;
        this.progress = new int[3];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commonTick() {
        super.commonTick();
        if (this.getPower() <= 50) {
            Arrays.fill(this.progress, 0);
            return;
        }
        IBacteriaStorage storage = this.getBacteriaStorage();
        int i = 0;
        while (i < this.progress.length) {
            block8: {
                block7: {
                    BacteriaInstance bacteria = storage.getBacteria(i);
                    if (bacteria.isEmpty()) break block7;
                    if (this.progress[i] > 100) {
                        Bacteria bacteria1 = BacteriaHelper.getBacteria((HolderLookup.Provider)this.level.registryAccess(), bacteria.getBacteria());
                        Bacteria.Resource resource = bacteria1.resource();
                        if (resource instanceof Bacteria.Resource.ItemResource) {
                            Item item2;
                            Bacteria.Resource.ItemResource itemResource = (Bacteria.Resource.ItemResource)resource;
                            try {
                                Item item;
                                item2 = item = itemResource.item();
                            }
                            catch (Throwable throwable) {
                                throw new MatchException(throwable.toString(), throwable);
                            }
                            this.getItemHandler().insertItem(i, item2.getDefaultInstance(), false);
                        }
                        this.progress[i] = 0;
                        break block8;
                    } else {
                        int n = i;
                        this.progress[n] = this.progress[n] + 1;
                    }
                    break block8;
                }
                this.progress[i] = 0;
            }
            ++i;
        }
    }

    @Override
    public Set<Direction> getLaserInputs() {
        return ObjectSet.of((Object[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST});
    }

    @Override
    public Set<Direction> getLaserOutputs() {
        return ObjectSet.of();
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        return Map.of();
    }

    @NotNull
    public Component getDisplayName() {
        return Component.literal((String)"Bio Reactor");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new BioReactorMenu(containerId, playerInventory, this);
    }

    @Override
    public MultiblockData getMultiblockData() {
        return this.multiblockData;
    }

    @Override
    public void setMultiblockData(MultiblockData data) {
        this.multiblockData = data;
    }

    @Override
    protected void saveData(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveData(tag, provider);
        tag.put("multiblockData", (Tag)this.saveMBData());
        tag.putIntArray("progress", this.progress);
    }

    @Override
    protected void loadData(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadData(tag, provider);
        this.multiblockData = this.loadMBData(tag.getCompound("multiblockData"));
        int[] progress = tag.getIntArray("progress");
        for (int i = 0; i < this.progress.length; ++i) {
            if (i >= progress.length) continue;
            this.progress[i] = progress[i];
        }
    }

    public int getProgress(int i) {
        return this.progress[i];
    }
}

