/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities;

import com.portingdeadmods.nautec.NTConfig;
import com.portingdeadmods.nautec.api.bacteria.Bacteria;
import com.portingdeadmods.nautec.api.bacteria.BacteriaInstance;
import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.content.menus.MutatorMenu;
import com.portingdeadmods.nautec.content.recipes.BacteriaMutationRecipe;
import com.portingdeadmods.nautec.content.recipes.inputs.BacteriaRecipeInput;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

public class MutatorBlockEntity
extends LaserBlockEntity
implements MenuProvider {
    public static final int MAX_PROGRESS = NTConfig.mutatorCraftingSpeed;
    public static final int POWER_USAGE = NTConfig.mutatorPowerUsage;
    private BacteriaMutationRecipe recipe;
    private int progress;

    public MutatorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.MUTATOR.get(), blockPos, blockState);
        this.addBacteriaStorage(2);
        this.addItemHandler(1);
    }

    @Override
    protected void onItemsChanged(int slot) {
        super.onItemsChanged(slot);
        this.checkRecipe();
    }

    private void checkRecipe() {
        ItemStack catalyst = this.getItemHandler().getStackInSlot(0);
        BacteriaInstance inputBacteria = this.getBacteriaStorage().getBacteria(0);
        BacteriaInstance resultBacteria = this.getBacteriaStorage().getBacteria(1);
        BacteriaMutationRecipe recipe1 = this.level.getRecipeManager().getRecipeFor(BacteriaMutationRecipe.TYPE, (RecipeInput)new BacteriaRecipeInput(inputBacteria, catalyst), this.level).map(RecipeHolder::value).orElse(null);
        this.recipe = recipe1 != null && (resultBacteria.isEmpty() || resultBacteria.is(recipe1.resultBacteria())) ? recipe1 : null;
    }

    @Override
    public void onBacteriaChanged(int slot) {
        super.onBacteriaChanged(slot);
        this.checkRecipe();
    }

    @Override
    public void commonTick() {
        super.commonTick();
        if (this.recipe != null) {
            if (this.getPower() >= POWER_USAGE) {
                if (this.progress >= MAX_PROGRESS) {
                    ResourceKey<Bacteria> resultBacteria = this.recipe.resultBacteria();
                    BacteriaInstance inputBacteria = this.getBacteriaStorage().getBacteria(0);
                    this.getBacteriaStorage().extractBacteria(0, inputBacteria.getSize(), false);
                    this.getBacteriaStorage().insertBacteria(1, BacteriaInstance.roll(resultBacteria, (HolderLookup.Provider)this.level.registryAccess()), false);
                    this.progress = 0;
                } else {
                    ++this.progress;
                }
            }
        } else {
            this.progress = 0;
        }
    }

    public int getProgress() {
        return this.progress;
    }

    @Override
    public Set<Direction> getLaserInputs() {
        return ObjectSet.of((Object)Direction.UP, (Object)Direction.DOWN);
    }

    @Override
    public Set<Direction> getLaserOutputs() {
        return ObjectSet.of();
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        return Map.of();
    }

    public Component getDisplayName() {
        return Component.literal((String)"Mutator");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new MutatorMenu(containerId, playerInventory, this);
    }
}

