/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities;

import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class LaserJunctionBlockEntity
extends LaserBlockEntity {
    private final Set<Direction> inputDirections = new ObjectOpenHashSet();
    private final Set<Direction> outputDirections = new ObjectOpenHashSet();

    public LaserJunctionBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.LASER_JUNCTION.get(), blockPos, blockState);
    }

    @Override
    public Set<Direction> getLaserInputs() {
        return this.inputDirections;
    }

    public String getLaserInputsAsString() {
        Set<Direction> inputs = this.getLaserInputs();
        if (inputs.isEmpty()) {
            return "No inputs";
        }
        return inputs.stream().map(direction -> StringUtils.capitalizeFirstLetter((String)direction.getName())).reduce((a, b) -> a + ", " + b).orElse("");
    }

    @Override
    public Set<Direction> getLaserOutputs() {
        return this.outputDirections;
    }

    public String getLaserOutputsAsString() {
        Set<Direction> outputs = this.getLaserOutputs();
        if (outputs.isEmpty()) {
            return "No outputs";
        }
        return outputs.stream().map(direction -> StringUtils.capitalizeFirstLetter((String)direction.getName())).reduce((a, b) -> a + ", " + b).orElse("");
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        return Map.of();
    }

    @Override
    public void commonTick() {
        super.commonTick();
        this.transmitPower(this.power);
    }
}

