/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.augments;

import com.portingdeadmods.nautec.api.augments.Augment;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import com.portingdeadmods.nautec.content.entites.ThrownSpreadingTrident;
import com.portingdeadmods.nautec.network.KeyPressedPayload;
import com.portingdeadmods.nautec.registries.NTAugments;
import com.portingdeadmods.nautec.registries.NTKeybinds;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class ThrowSpreadingTrident
extends Augment {
    private static final float SPREAD_ANGLE = 8.0f;

    public ThrowSpreadingTrident(AugmentSlot augmentSlot) {
        super(NTAugments.SPREADING_TRIDENT_AUGMENT.get(), augmentSlot);
    }

    @Override
    public void clientTick(PlayerTickEvent.Post event) {
        if (((KeyMapping)NTKeybinds.THROW_SPREADING_KEYBIND.get()).consumeClick() && !this.isOnCooldown()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new KeyPressedPayload(this.augmentSlot), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.handleKeybindPress();
        }
    }

    @Override
    public void handleKeybindPress() {
        if (!this.player.level().isClientSide()) {
            ThrownSpreadingTrident trident = new ThrownSpreadingTrident(this.player.level(), (LivingEntity)this.player, Items.TRIDENT.getDefaultInstance(), 1);
            trident.shootFromRotation((Entity)this.player, this.player.getXRot(), this.player.getYRot(), 0.0f, 1.5f, 0.0f);
            this.player.level().addFreshEntity((Entity)trident);
        }
        this.setCooldown(20);
    }
}

