/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.augments;

import com.portingdeadmods.nautec.api.augments.Augment;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import com.portingdeadmods.nautec.registries.NTAugments;
import com.portingdeadmods.nautec.registries.NTKeybinds;
import com.portingdeadmods.nautec.utils.MathUtils;
import net.minecraft.client.KeyMapping;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class LeapAugment
extends Augment {
    public LeapAugment(AugmentSlot augmentSlot) {
        super(NTAugments.LEAP_AUGMENT.get(), augmentSlot);
    }

    @Override
    public void clientTick(PlayerTickEvent.Post event) {
        if (((KeyMapping)NTKeybinds.LEAP_KEYBIND.get()).consumeClick() && !this.isOnCooldown() && event.getEntity().onGround()) {
            this.handleKeybindPress();
        }
    }

    @Override
    public void handleKeybindPress() {
        Vec3 lookVec = this.player.getLookAngle();
        float magnitude = 1.8f;
        Vec3 leapVector = new Vec3(lookVec.x, lookVec.y, lookVec.z);
        float initialYaw = (float)Math.atan2(leapVector.z, leapVector.x);
        double leapPitch = Math.toDegrees(Math.asin(leapVector.y / (leapVector = MathUtils.rotateYaw(leapVector, initialYaw)).length()));
        if (leapPitch > 80.0) {
            leapVector = new Vec3(0.0, 1.0, 0.0);
            leapPitch = 90.0;
        } else {
            leapVector = MathUtils.rotateRoll(leapVector, (float)Math.toRadians(-10.0));
            leapVector = MathUtils.rotateYaw(leapVector, -initialYaw);
            leapVector = leapVector.normalize();
        }
        double coefficient = 1.6 - MathUtils.map(Math.abs(leapPitch), 0.0, 90.0, 0.6, 1.0);
        leapVector = leapVector.scale((double)magnitude * coefficient);
        this.player.setDeltaMovement(leapVector);
        this.player.hasImpulse = true;
        this.setCooldown(25);
        this.player.playSound(SoundEvents.UI_TOAST_IN, 2.0f, 1.0f);
        this.player.playSound(SoundEvents.UI_TOAST_IN, 1.5f, 0.8f);
    }
}

