/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.compat.jei.categories;

import com.portingdeadmods.nautec.api.bacteria.Bacteria;
import com.portingdeadmods.nautec.compat.jei.categories.BacteriaCategory;
import com.portingdeadmods.nautec.registries.NTBlocks;
import com.portingdeadmods.nautec.utils.BacteriaHelper;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class BioReactorCategory
extends BacteriaCategory<BioReactorRecipe> {
    static final ResourceLocation RIGHT_ARROW_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"container/bio_reactor/progress_arrow_off");
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"bio_reactor");
    public static final RecipeType<BioReactorRecipe> RECIPE_TYPE = new RecipeType(UID, BioReactorRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public BioReactorCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(96, 24);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)NTBlocks.BIO_REACTOR.get()));
    }

    public RecipeType<BioReactorRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.literal((String)"Bio Reactor");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BioReactorRecipe recipe, IFocusGroup focuses) {
        Bacteria.Resource resource = recipe.resource();
        if (resource instanceof Bacteria.Resource.ItemResource) {
            Item item;
            Bacteria.Resource.ItemResource itemResource = (Bacteria.Resource.ItemResource)resource;
            try {
                Item item2;
                item = item2 = itemResource.item();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            builder.addOutputSlot(this.getWidth() - 18, 3).addItemLike((ItemLike)item);
        }
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(recipe.getInputDish());
        this.addBacteriaSlot(recipe, 0, 3, recipe.bacteria);
    }

    @Override
    public void draw(BioReactorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        guiGraphics.blitSprite(RIGHT_ARROW_SPRITE, this.getWidth() / 2 - 12, this.getHeight() / 2 - 5, 24, 10);
    }

    public record BioReactorRecipe(ResourceKey<Bacteria> bacteria, Bacteria.Resource resource) {
        public static final String NAME = "bio_reactor";

        public ItemStack getInputDish() {
            return BacteriaHelper.getMaxStatDish(this.bacteria, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
        }
    }
}

