/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.compat.jei.categories;

import com.portingdeadmods.nautec.compat.jei.categories.BacteriaCategory;
import com.portingdeadmods.nautec.content.recipes.BacteriaMutationRecipe;
import com.portingdeadmods.nautec.registries.NTBlocks;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BacteriaMutationsCategory
extends BacteriaCategory<BacteriaMutationRecipe> {
    static final ResourceLocation SINGLE_SLOT_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"container/furnace/empty_slot");
    static final ResourceLocation BACTERIA_SLOT_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"container/bacteria_slot");
    static final ResourceLocation RIGHT_ARROW_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"container/mutator/progress_arrow_off");
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"bacteria_mutation");
    public static final RecipeType<BacteriaMutationRecipe> RECIPE_TYPE = new RecipeType(UID, BacteriaMutationRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final int gap = 5;
    private final int slotSize = 18;
    private final int arrowWidth = 62;
    private final int arrowHeight = 14;
    private final int YGapBetweenInCata = 29;
    private final int gapBetweenSlotArrow = 3;
    private final int drawableWidth = 114;
    private final int drawableHeight = 65;
    private final int gapBetweenInOut = 25;

    public BacteriaMutationsCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(114, 65);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)NTBlocks.MUTATOR.get()));
    }

    public RecipeType<BacteriaMutationRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.literal((String)"Bacteria Mutations");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BacteriaMutationRecipe recipe, IFocusGroup focuses) {
        this.addBacteriaSlot(recipe, 4, 12, recipe.inputBacteria());
        this.addBacteriaSlot(recipe, 91, 12, recipe.resultBacteria());
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(recipe.getInputDish());
        builder.addSlot(RecipeIngredientRole.INPUT, 49, 42).addIngredients(recipe.catalyst());
    }

    @Override
    public void draw(@NotNull BacteriaMutationRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.blitSprite(RIGHT_ARROW_SPRITE, 26, 12, 62, 14);
        guiGraphics.blitSprite(SINGLE_SLOT_SPRITE, 48, 41, 18, 18);
        Font font = Minecraft.getInstance().font;
        String purityString = recipe.chance() + "%";
        int width = font.width(purityString);
        int n = 91 - (width - 18) / 2;
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, purityString, n, 10 - 9, -8355712, false);
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }
}

