/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.compat.jei;

import com.portingdeadmods.nautec.NTRegistries;
import com.portingdeadmods.nautec.api.bacteria.Bacteria;
import com.portingdeadmods.nautec.compat.jei.categories.AquaticCatalystChannelingRecipeCategory;
import com.portingdeadmods.nautec.compat.jei.categories.AugmentationRecipeCategory;
import com.portingdeadmods.nautec.compat.jei.categories.BacteriaGraftingCategory;
import com.portingdeadmods.nautec.compat.jei.categories.BacteriaIncubationCategory;
import com.portingdeadmods.nautec.compat.jei.categories.BacteriaMutationsCategory;
import com.portingdeadmods.nautec.compat.jei.categories.BioReactorCategory;
import com.portingdeadmods.nautec.compat.jei.categories.ItemEtchingRecipeCategory;
import com.portingdeadmods.nautec.compat.jei.categories.ItemTransformationRecipeCategory;
import com.portingdeadmods.nautec.compat.jei.categories.MixingRecipeCategory;
import com.portingdeadmods.nautec.content.recipes.AquaticCatalystChannelingRecipe;
import com.portingdeadmods.nautec.content.recipes.AugmentationRecipe;
import com.portingdeadmods.nautec.content.recipes.BacteriaIncubationRecipe;
import com.portingdeadmods.nautec.content.recipes.BacteriaMutationRecipe;
import com.portingdeadmods.nautec.content.recipes.ItemEtchingRecipe;
import com.portingdeadmods.nautec.content.recipes.ItemTransformationRecipe;
import com.portingdeadmods.nautec.content.recipes.MixingRecipe;
import com.portingdeadmods.nautec.data.NTDataMaps;
import com.portingdeadmods.nautec.data.maps.BacteriaObtainValue;
import com.portingdeadmods.nautec.registries.NTBacterias;
import com.portingdeadmods.nautec.registries.NTBlocks;
import com.portingdeadmods.nautec.registries.NTFluids;
import com.portingdeadmods.nautec.registries.NTItems;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class NTJeiPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ItemTransformationRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AquaticCatalystChannelingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ItemEtchingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new MixingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AugmentationRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BacteriaMutationsCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BacteriaIncubationCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BioReactorCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BacteriaGraftingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[0]);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Minecraft.getInstance().level;
        RecipeManager recipeManager = level.getRecipeManager();
        RegistryAccess registryAccess = level.registryAccess();
        List<ItemTransformationRecipe> transformationRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ItemTransformationRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).toList();
        List<AquaticCatalystChannelingRecipe> channelingRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)AquaticCatalystChannelingRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).toList();
        List<ItemEtchingRecipe> etchingRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ItemEtchingRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).toList();
        List<MixingRecipe> mixingRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)MixingRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).toList();
        List<AugmentationRecipe> augmentationRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)AugmentationRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).toList();
        List<BacteriaMutationRecipe> mutationRecipes = recipeManager.getAllRecipesFor(BacteriaMutationRecipe.TYPE).stream().map(RecipeHolder::value).toList();
        List<BacteriaIncubationRecipe> incubationRecipes = recipeManager.getAllRecipesFor(BacteriaIncubationRecipe.TYPE).stream().map(RecipeHolder::value).toList();
        Registry registry = registryAccess.registryOrThrow(NTRegistries.BACTERIA_KEY);
        List<BioReactorCategory.BioReactorRecipe> bioReactorRecipes = registry.entrySet().stream().map(entry -> new BioReactorCategory.BioReactorRecipe((ResourceKey<Bacteria>)((ResourceKey)entry.getKey()), ((Bacteria)entry.getValue()).resource())).filter(recipe -> !recipe.bacteria().equals(NTBacterias.EMPTY) && !recipe.resource().isEmpty()).toList();
        Map dataMap = BuiltInRegistries.BLOCK.getDataMap(NTDataMaps.BACTERIA_OBTAINING);
        List<BacteriaGraftingCategory.GraftingRecipe> graftingRecipes = dataMap.entrySet().stream().map(entry -> new BacteriaGraftingCategory.GraftingRecipe((Block)registryAccess.holderOrThrow((ResourceKey)entry.getKey()).value(), (BacteriaObtainValue)entry.getValue())).toList();
        registration.addRecipes(AugmentationRecipeCategory.RECIPE_TYPE, augmentationRecipes);
        registration.addRecipes(ItemTransformationRecipeCategory.RECIPE_TYPE, transformationRecipes);
        registration.addRecipes(AquaticCatalystChannelingRecipeCategory.RECIPE_TYPE, channelingRecipes);
        registration.addRecipes(ItemEtchingRecipeCategory.RECIPE_TYPE, etchingRecipes);
        registration.addRecipes(MixingRecipeCategory.RECIPE_TYPE, mixingRecipes);
        registration.addRecipes(BacteriaMutationsCategory.RECIPE_TYPE, mutationRecipes);
        registration.addRecipes(BacteriaIncubationCategory.RECIPE_TYPE, incubationRecipes);
        registration.addRecipes(BioReactorCategory.RECIPE_TYPE, bioReactorRecipes);
        registration.addRecipes(BacteriaGraftingCategory.RECIPE_TYPE, graftingRecipes);
        for (AugmentationRecipe recipe2 : augmentationRecipes) {
            registration.addIngredientInfo((Object)recipe2.augmentItem().getDefaultInstance(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)recipe2.desc())});
        }
        registration.addIngredientInfo((Object)NTItems.PRISMARINE_CRYSTAL_SHARD.toStack(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.literal((String)"Prismarine Crystal Shards are pristine crystals, capable of channeling power like no other material. They can be obtained by breaking a prismarine crystal using an Aquarine Steel Pickaxe with its ability enabled.")});
        registration.addIngredientInfo(List.of(NTItems.BROKEN_WHISK.toStack(), NTItems.BURNT_COIL.toStack(), NTItems.ANCIENT_VALVE.toStack(), NTItems.RUSTY_GEAR.toStack()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.literal((String)"These ancient machine components can be found in chests and are dropped by underwater mobs")});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NTBlocks.AQUATIC_CATALYST.get()), new RecipeType[]{AquaticCatalystChannelingRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NTFluids.ETCHING_ACID.getBucket()), new RecipeType[]{ItemEtchingRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NTBlocks.MIXER.get()), new RecipeType[]{MixingRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NTBlocks.AUGMENTATION_STATION.get()), new RecipeType[]{AugmentationRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NTBlocks.MUTATOR.get()), new RecipeType[]{BacteriaMutationsCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NTBlocks.INCUBATOR.get()), new RecipeType[]{BacteriaIncubationCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NTBlocks.BIO_REACTOR.get()), new RecipeType[]{BioReactorCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NTItems.GRAFTING_TOOL.get()), new RecipeType[]{BacteriaGraftingCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NTItems.PETRI_DISH.get()), new RecipeType[]{BacteriaGraftingCategory.RECIPE_TYPE});
    }
}

