/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.client.renderer.blockentities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.portingdeadmods.nautec.content.blockentities.ChargerBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ChargerBERenderer
implements BlockEntityRenderer<ChargerBlockEntity> {
    public ChargerBERenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(ChargerBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ChargerBERenderer.renderFloatingItem(blockEntity.getItemHandler().getStackInSlot(0), poseStack, bufferSource, packedLight, packedOverlay, 0.4f);
    }

    public static void renderFloatingItem(ItemStack stack, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLight, int combinedOverlay, float yPos) {
        Minecraft minecraft = Minecraft.getInstance();
        if (!stack.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5, (double)yPos, 0.5);
            float scale = stack.getItem() instanceof BlockItem ? 0.95f : 0.75f;
            poseStack.scale(scale, scale, scale);
            double tick = (double)System.currentTimeMillis() / 800.0;
            poseStack.translate(0.0, Math.sin(tick % (Math.PI * 2)) * 0.065, 0.0);
            poseStack.mulPose(Axis.YP.rotationDegrees((float)(tick * 40.0 % 360.0)));
            minecraft.getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, combinedLight, combinedOverlay, poseStack, multiBufferSource, (Level)minecraft.level, 0);
            poseStack.popPose();
        }
    }
}

