/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.api.multiblocks;

import com.portingdeadmods.nautec.api.blockentities.multiblock.MultiblockEntity;
import com.portingdeadmods.nautec.api.multiblocks.MultiblockData;
import com.portingdeadmods.nautec.api.multiblocks.MultiblockLayer;
import com.portingdeadmods.nautec.api.utils.HorizontalDirection;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import org.apache.commons.lang3.IntegerRange;
import org.jetbrains.annotations.Nullable;

public interface Multiblock {
    public static final BooleanProperty FORMED = BooleanProperty.create((String)"formed");

    public Block getUnformedController();

    public Block getFormedController();

    public MultiblockLayer[] getLayout();

    public Map<Integer, Block> getDefinition();

    public BlockEntityType<? extends MultiblockEntity> getMultiBlockEntityType();

    default public void iterBlock(Level level, BlockPos blockPos, BlockPos controllerPos, int layerIndex, int layoutIndex, MultiblockData data, boolean forming) {
    }

    default public List<IntIntPair> getWidths() {
        ArrayList<IntIntPair> widths = new ArrayList<IntIntPair>(this.getMaxSize());
        for (MultiblockLayer layer : this.getLayout()) {
            if (layer.dynamic()) {
                for (int i = 0; i < (Integer)layer.range().getMaximum(); ++i) {
                    widths.add(layer.getWidths());
                }
                continue;
            }
            widths.add(layer.getWidths());
        }
        return widths;
    }

    @Nullable
    public BlockState formBlock(Level var1, BlockPos var2, BlockPos var3, int var4, int var5, MultiblockData var6, @Nullable Player var7);

    default public void afterFormBlock(Level level, BlockPos blockPos, BlockPos controllerPos, int layerIndex, int layoutIndex, MultiblockData multiblockData, @Nullable Player player) {
    }

    default public void afterUnformBlock(Level level, BlockPos blockPos, BlockPos controllerPos, int layerIndex, int layoutIndex, HorizontalDirection direction, @Nullable Player player) {
    }

    public boolean isFormed(Level var1, BlockPos var2);

    default public void onStartForming(Level level, BlockPos firstPos, BlockPos controllerPos) {
    }

    default public void onStartUnforming(Level level, BlockPos firstPos, BlockPos controllerPos) {
    }

    @Nullable
    default public HorizontalDirection getFixedDirection() {
        return null;
    }

    default public int getMaxSize() {
        int maxSize = 0;
        for (MultiblockLayer layer : this.getLayout()) {
            maxSize += ((Integer)layer.range().getMaximum()).intValue();
        }
        return maxSize;
    }

    default public MultiblockLayer layer(int ... layer) {
        return new MultiblockLayer(false, IntegerRange.of((int)1, (int)1), layer);
    }
}

