/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.api.bacteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.nautec.api.bacteria.Bacteria;
import com.portingdeadmods.nautec.api.bacteria.CollapsedBacteriaStats;
import com.portingdeadmods.nautec.content.bacteria.SimpleCollapsedStats;
import com.portingdeadmods.nautec.registries.NTBacterias;
import com.portingdeadmods.nautec.utils.BacteriaHelper;
import com.portingdeadmods.nautec.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;

public final class BacteriaInstance {
    public static final BacteriaInstance EMPTY = new BacteriaInstance(NTBacterias.EMPTY, 0L, SimpleCollapsedStats.EMPTY, false);
    public static final Codec<BacteriaInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Bacteria.BACTERIA_TYPE_CODEC.fieldOf("bacteria").forGetter(BacteriaInstance::getBacteria), (App)Codec.LONG.fieldOf("amount").forGetter(BacteriaInstance::getSize), (App)CollapsedBacteriaStats.CODEC.fieldOf("stats").forGetter(BacteriaInstance::getStats), (App)Codec.BOOL.fieldOf("analyzed").forGetter(BacteriaInstance::isAnalyzed)).apply((Applicative)instance, BacteriaInstance::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BacteriaInstance> STREAM_CODEC = StreamCodec.composite(Bacteria.BACTERIA_TYPE_STREAM_CODEC, BacteriaInstance::getBacteria, (StreamCodec)ByteBufCodecs.VAR_LONG, BacteriaInstance::getSize, CollapsedBacteriaStats.STREAM_CODEC, BacteriaInstance::getStats, (StreamCodec)ByteBufCodecs.BOOL, BacteriaInstance::isAnalyzed, BacteriaInstance::new);
    private final ResourceKey<Bacteria> bacteria;
    private long size;
    private CollapsedBacteriaStats stats;
    private boolean analyzed;

    public BacteriaInstance(ResourceKey<Bacteria> bacteria, long size, CollapsedBacteriaStats stats, boolean analyzed) {
        this.bacteria = bacteria;
        this.size = size;
        this.stats = stats;
        this.analyzed = analyzed;
    }

    public static BacteriaInstance roll(ResourceKey<Bacteria> bacteria, HolderLookup.Provider lookupProvider) {
        Bacteria bacteria1 = BacteriaHelper.getBacteria(lookupProvider, bacteria);
        return new BacteriaInstance(bacteria, bacteria1.rollSize(), (CollapsedBacteriaStats)bacteria1.stats().collapse(), false);
    }

    public static BacteriaInstance withMaxStats(ResourceKey<Bacteria> bacteria, HolderLookup.Provider lookupProvider) {
        Bacteria bacteria1 = BacteriaHelper.getBacteria(lookupProvider, bacteria);
        return new BacteriaInstance(bacteria, bacteria1.maxInitialSize(), (CollapsedBacteriaStats)bacteria1.stats().collapseMaxStats(), true);
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public ResourceKey<Bacteria> getBacteria() {
        return this.bacteria;
    }

    public void setStats(CollapsedBacteriaStats stats) {
        this.stats = stats;
    }

    public CollapsedBacteriaStats getStats() {
        return this.stats;
    }

    public BacteriaInstance rollStats() {
        this.stats = this.stats.rollStats();
        return this;
    }

    public void setAnalyzed(boolean analyzed) {
        this.analyzed = analyzed;
    }

    public boolean isAnalyzed() {
        return this.analyzed;
    }

    public BacteriaInstance copy() {
        return new BacteriaInstance(this.bacteria, this.size, this.stats.copy(), this.analyzed);
    }

    public BacteriaInstance copyWithSize(long size) {
        if (size > 0L) {
            return new BacteriaInstance(this.bacteria, size, this.stats.copy(), this.analyzed);
        }
        return EMPTY;
    }

    public void shrink(int amount) {
        this.setSize(this.getSize() - (long)amount);
    }

    public void grow(int amount) {
        this.setSize(this.getSize() + (long)amount);
    }

    public boolean is(ResourceKey<Bacteria> bacteria) {
        return this.bacteria.equals(bacteria);
    }

    public boolean isEmpty() {
        return this.bacteria == NTBacterias.EMPTY;
    }

    public Component getName() {
        return Utils.registryTranslation(this.bacteria);
    }

    public List<Component> getTooltip() {
        return this.getTooltip(false, this.analyzed);
    }

    public List<Component> getTooltip(boolean showAnalyzedValues) {
        return this.getTooltip(showAnalyzedValues, this.analyzed);
    }

    public List<Component> getTooltip(boolean showMutatorValues, boolean analyzed) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(this.getName());
        MutableComponent statsCaption = Component.literal((String)"Stats: ").withStyle(ChatFormatting.WHITE);
        if (analyzed) {
            tooltip.add((Component)Component.literal((String)("Size: " + this.size)));
            tooltip.add((Component)statsCaption);
            tooltip.addAll(showMutatorValues ? this.stats.statsTooltipWithMutatorValues() : this.stats.statsTooltip());
        } else {
            statsCaption.append((Component)Component.literal((String)"???").withStyle(ChatFormatting.YELLOW));
            tooltip.add((Component)statsCaption);
        }
        return tooltip;
    }

    public List<Component> getExpandableTooltip(boolean hasShiftDown, boolean hasControlDown) {
        ArrayList<Component> tooltipComponents = new ArrayList<Component>();
        tooltipComponents.add((Component)Component.literal((String)"Name: ").append(Utils.registryTranslation(this.bacteria)).withStyle(ChatFormatting.WHITE));
        if (this.bacteria != NTBacterias.EMPTY) {
            MutableComponent statsCaption = Component.literal((String)"Stats: ").withStyle(ChatFormatting.WHITE);
            if (this.isAnalyzed()) {
                tooltipComponents.add((Component)Component.literal((String)("Size: " + this.size)));
                if (!hasShiftDown) {
                    statsCaption.append((Component)Component.literal((String)"<").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"Shift").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)">").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" and ").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"<").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"Control").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)">").withStyle(ChatFormatting.WHITE));
                }
                tooltipComponents.add((Component)statsCaption);
                if (hasShiftDown && hasControlDown) {
                    tooltipComponents.add(BacteriaHelper.resourceTooltip(this.bacteria));
                    for (Component tooltipComponent : this.getStats().statsTooltipWithMutatorValues()) {
                        tooltipComponents.add((Component)Component.literal((String)" ".repeat(2)).append(tooltipComponent));
                    }
                }
                if (hasShiftDown && !hasControlDown) {
                    tooltipComponents.add(BacteriaHelper.resourceTooltip(this.bacteria));
                    for (Component tooltipComponent : this.getStats().statsTooltip()) {
                        tooltipComponents.add((Component)Component.literal((String)" ".repeat(2)).append(tooltipComponent));
                    }
                }
            } else {
                statsCaption.append((Component)Component.literal((String)"???").withStyle(ChatFormatting.YELLOW));
                tooltipComponents.add((Component)statsCaption);
            }
        }
        return tooltipComponents;
    }

    public static boolean isSameBacteriaAndStats(BacteriaInstance a, BacteriaInstance b) {
        return a.bacteria.equals(b.bacteria) && a.stats.equals(b.stats);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BacteriaInstance)) {
            return false;
        }
        BacteriaInstance instance = (BacteriaInstance)o;
        return this.size == instance.size && this.analyzed == instance.analyzed && Objects.equals(this.bacteria, instance.bacteria) && Objects.equals(this.stats, instance.stats);
    }

    public int hashCode() {
        return Objects.hash(this.bacteria, this.size, this.stats, this.analyzed);
    }
}

