/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.api.bacteria;

import com.mojang.serialization.Codec;
import com.portingdeadmods.nautec.NTRegistries;
import com.portingdeadmods.nautec.api.bacteria.BacteriaSerializer;
import com.portingdeadmods.nautec.api.bacteria.BacteriaStats;
import com.portingdeadmods.nautec.utils.codec.CodecUtils;
import com.portingdeadmods.nautec.utils.ranges.LongRange;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public interface Bacteria {
    public static final Codec<ResourceKey<Bacteria>> BACTERIA_TYPE_CODEC = ResourceKey.codec(NTRegistries.BACTERIA_KEY);
    public static final StreamCodec<ByteBuf, ResourceKey<Bacteria>> BACTERIA_TYPE_STREAM_CODEC = ResourceKey.streamCodec(NTRegistries.BACTERIA_KEY);
    public static final Codec<Bacteria> CODEC = NTRegistries.BACTERIA_SERIALIZER.byNameCodec().dispatch(Bacteria::getSerializer, BacteriaSerializer::mapCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, Bacteria> STREAM_CODEC = ByteBufCodecs.registry(NTRegistries.BACTERIA_SERIALIZER_KEY).dispatch(Bacteria::getSerializer, BacteriaSerializer::streamCodec);

    public LongRange initialSize();

    public Resource resource();

    public BacteriaStats<?> stats();

    public BacteriaSerializer<?> getSerializer();

    public long rollSize();

    default public long maxInitialSize() {
        return (Long)this.initialSize().getMax();
    }

    public static interface Builder<T extends Bacteria> {
        public T build();
    }

    public static interface Resource {
        public Codec<? extends Resource> codec();

        public StreamCodec<ByteBuf, ? extends Resource> streamCodec();

        public boolean isEmpty();

        public record ItemResource(Item item) implements Resource
        {
            public static final Codec<ItemResource> CODEC = CodecUtils.ITEM_CODEC.xmap(ItemResource::new, ItemResource::item);
            public static final StreamCodec<ByteBuf, ItemResource> STREAM_CODEC = CodecUtils.ITEM_STREAM_CODEC.map(ItemResource::new, ItemResource::item);

            public Codec<ItemResource> codec() {
                return CODEC;
            }

            public StreamCodec<ByteBuf, ItemResource> streamCodec() {
                return STREAM_CODEC;
            }

            @Override
            public boolean isEmpty() {
                return this.item == null || this.item == Items.AIR;
            }
        }
    }
}

