/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.api.augments;

import com.portingdeadmods.nautec.NTRegistries;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import com.portingdeadmods.nautec.api.augments.AugmentType;
import com.portingdeadmods.nautec.data.NTDataAttachments;
import com.portingdeadmods.nautec.utils.AugmentClientHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public abstract class Augment
implements INBTSerializable<CompoundTag> {
    protected final AugmentType<?> augmentType;
    protected Player player;
    protected final AugmentSlot augmentSlot;
    private int cooldown;

    public Augment(AugmentType<?> augmentType, AugmentSlot augmentSlot) {
        this.augmentType = augmentType;
        this.augmentSlot = augmentSlot;
    }

    public boolean replaceBodyPart() {
        return false;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public AugmentType<?> getAugmentType() {
        return this.augmentType;
    }

    public Player getPlayer() {
        return this.player;
    }

    public AugmentSlot getAugmentSlot() {
        return this.augmentSlot;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
        this.setChanged();
    }

    public void onAdded(Player player) {
    }

    public void onRemoved(Player player) {
    }

    public void commonTick(PlayerTickEvent.Post event) {
        if (this.player == null) {
            return;
        }
        if (this.isOnCooldown()) {
            this.setCooldown(this.getCooldown() - 1);
        }
        if (this.player.level().isClientSide) {
            this.clientTick(event);
        } else {
            this.serverTick(event);
        }
    }

    @Deprecated
    public void clientTick(PlayerTickEvent.Post event) {
    }

    @Deprecated
    public void serverTick(PlayerTickEvent.Post event) {
    }

    public void fall(LivingFallEvent event) {
    }

    public void handleKeybindPress() {
    }

    public boolean isOnCooldown() {
        return this.getCooldown() > 0;
    }

    protected final void setChanged() {
        this.player.setData(NTDataAttachments.AUGMENT_DATA_CHANGED, (Object)NTRegistries.AUGMENT_SLOT.getId((Object)this.augmentSlot));
        if (this.player.level().isClientSide) {
            AugmentClientHelper.invalidateCacheFor(this.player, this.augmentSlot);
        }
    }

    public @UnknownNullability CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("cooldown", this.cooldown);
        return tag;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
        this.cooldown = nbt.getInt("cooldown");
    }
}

