/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec;

import com.mojang.logging.LogUtils;
import com.portingdeadmods.nautec.NTConfig;
import com.portingdeadmods.nautec.NTRegistries;
import com.portingdeadmods.nautec.api.bacteria.Bacteria;
import com.portingdeadmods.nautec.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.nautec.api.items.IBacteriaItem;
import com.portingdeadmods.nautec.api.items.ICurioItem;
import com.portingdeadmods.nautec.api.items.IFluidItem;
import com.portingdeadmods.nautec.api.items.IPowerItem;
import com.portingdeadmods.nautec.capabilities.NTCapabilities;
import com.portingdeadmods.nautec.capabilities.bacteria.ItemBacteriaWrapper;
import com.portingdeadmods.nautec.capabilities.power.ItemPowerWrapper;
import com.portingdeadmods.nautec.compat.duradisplay.DuraDisplayCompat;
import com.portingdeadmods.nautec.content.commands.arguments.AugmentSlotArgumentType;
import com.portingdeadmods.nautec.content.commands.arguments.AugmentTypeArgumentType;
import com.portingdeadmods.nautec.data.NTDataAttachments;
import com.portingdeadmods.nautec.data.NTDataComponents;
import com.portingdeadmods.nautec.data.NTDataMaps;
import com.portingdeadmods.nautec.registries.NTArgumentTypes;
import com.portingdeadmods.nautec.registries.NTAttachmentTypes;
import com.portingdeadmods.nautec.registries.NTAugmentSlots;
import com.portingdeadmods.nautec.registries.NTAugments;
import com.portingdeadmods.nautec.registries.NTBacteriaSerializers;
import com.portingdeadmods.nautec.registries.NTBacteriaStatsSerializers;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import com.portingdeadmods.nautec.registries.NTBlocks;
import com.portingdeadmods.nautec.registries.NTCreativeTabs;
import com.portingdeadmods.nautec.registries.NTEntities;
import com.portingdeadmods.nautec.registries.NTFluids;
import com.portingdeadmods.nautec.registries.NTItems;
import com.portingdeadmods.nautec.registries.NTLootModifier;
import com.portingdeadmods.nautec.registries.NTMenuTypes;
import com.portingdeadmods.nautec.registries.NTMultiblocks;
import com.portingdeadmods.nautec.registries.NTRecipes;
import com.portingdeadmods.nautec.registries.NTStructures;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod(value="nautec")
public final class Nautec {
    public static final String MODID = "nautec";
    public static final String MODNAME = "NauTec";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Nautec(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(NewRegistryEvent.class, event -> {
            event.register(NTRegistries.MULTIBLOCK);
            event.register(NTRegistries.AUGMENT_SLOT);
            event.register(NTRegistries.AUGMENT_TYPE);
            event.register(NTRegistries.BACTERIA_SERIALIZER);
            event.register(NTRegistries.BACTERIA_STATS_SERIALIZER);
        });
        modEventBus.addListener(DataPackRegistryEvent.NewRegistry.class, event -> event.dataPackRegistry(NTRegistries.BACTERIA_KEY, Bacteria.CODEC, Bacteria.CODEC));
        NTEntities.ENTITIES.register(modEventBus);
        NTItems.ITEMS.register(modEventBus);
        NTBlocks.BLOCKS.register(modEventBus);
        NTRecipes.SERIALIZERS.register(modEventBus);
        NTDataAttachments.ATTACHMENTS.register(modEventBus);
        NTArgumentTypes.ARGUMENT_TYPES.register(modEventBus);
        NTBlockEntityTypes.BLOCK_ENTITIES.register(modEventBus);
        NTCreativeTabs.CREATIVE_MODE_TABS.register(modEventBus);
        NTDataComponents.DATA_COMPONENT_TYPES.register(modEventBus);
        NTAttachmentTypes.ATTACHMENT_TYPES.register(modEventBus);
        NTMultiblocks.MULTIBLOCKS.register(modEventBus);
        NTAugments.AUGMENTS.register(modEventBus);
        NTAugmentSlots.AUGMENT_SLOTS.register(modEventBus);
        NTMenuTypes.MENUS.register(modEventBus);
        NTStructures.STRUCTURES.register(modEventBus);
        NTLootModifier.LOOT_MODIFIERS.register(modEventBus);
        NTBacteriaSerializers.SERIALIZERS.register(modEventBus);
        NTBacteriaStatsSerializers.SERIALIZERS.register(modEventBus);
        NTFluids.HELPER.register(modEventBus);
        modEventBus.addListener(this::registerDataMaps);
        modEventBus.addListener(this::onRegisterAugments);
        modEventBus.addListener(this::registerCapabilities);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)NTConfig.SPEC);
        if (ModList.get().isLoaded("duradisplay")) {
            DuraDisplayCompat.register();
        }
    }

    private void registerDataMaps(RegisterDataMapTypesEvent event) {
        event.register(NTDataMaps.BACTERIA_OBTAINING);
    }

    private void onRegisterAugments(RegisterEvent event) {
        Registry augmentRegistry;
        Registry slotRegistry = event.getRegistry(NTRegistries.AUGMENT_SLOT.key());
        if (slotRegistry != null) {
            AugmentSlotArgumentType.suggestions = slotRegistry.keySet().stream().map(Objects::toString).collect(Collectors.toSet());
        }
        if ((augmentRegistry = event.getRegistry(NTRegistries.AUGMENT_TYPE.key())) != null) {
            AugmentTypeArgumentType.suggestions = augmentRegistry.keySet().stream().map(Objects::toString).collect(Collectors.toSet());
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        Nautec.registerItemCaps(event);
        Nautec.registerBECaps(event);
    }

    private static void registerItemCaps(RegisterCapabilitiesEvent event) {
        for (Item item : BuiltInRegistries.ITEM) {
            if (item instanceof IPowerItem) {
                IPowerItem powerItem = (IPowerItem)item;
                event.registerItem(NTCapabilities.PowerStorage.ITEM, (stack, ctx) -> new ItemPowerWrapper((ItemStack)stack, powerItem), new ItemLike[]{item});
            }
            if (item instanceof IFluidItem) {
                IFluidItem fluidItem = (IFluidItem)item;
                event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new FluidHandlerItemStack(NTDataComponents.FLUID, stack, fluidItem.getFluidCapacity()), new ItemLike[]{item});
            }
            if (item instanceof IBacteriaItem) {
                event.registerItem(NTCapabilities.BacteriaStorage.ITEM, (stack, ctx) -> new ItemBacteriaWrapper(NTDataComponents.BACTERIA, (ItemStack)stack), new ItemLike[]{item});
            }
            if (!(item instanceof ICurioItem)) continue;
            ICurioItem curioItem = (ICurioItem)item;
            event.registerItem(CuriosCapability.ITEM, (stack, context) -> new ICurio(){
                final /* synthetic */ ItemStack val$stack;
                final /* synthetic */ ICurioItem val$curioItem;
                {
                    this.val$stack = itemStack;
                    this.val$curioItem = iCurioItem;
                }

                public ItemStack getStack() {
                    return this.val$stack;
                }

                public void curioTick(SlotContext slotContext) {
                    this.val$curioItem.curioTick(this.val$stack, slotContext);
                }
            }, new ItemLike[]{item});
        }
    }

    private static void registerBECaps(RegisterCapabilitiesEvent event) {
        for (DeferredHolder be : NTBlockEntityTypes.BLOCK_ENTITIES.getEntries()) {
            Block validBlock = (Block)((BlockEntityType)be.get()).getValidBlocks().stream().iterator().next();
            BlockEntity testBE = ((BlockEntityType)be.get()).create(BlockPos.ZERO, validBlock.defaultBlockState());
            if (!(testBE instanceof ContainerBlockEntity)) continue;
            ContainerBlockEntity containerBE = (ContainerBlockEntity)testBE;
            if (containerBE.getPowerStorage() != null) {
                event.registerBlockEntity(NTCapabilities.PowerStorage.BLOCK, (BlockEntityType)be.get(), (blockEntity, dir) -> ((ContainerBlockEntity)((Object)blockEntity)).getPowerStorage());
            }
            if (containerBE.getItemHandler() != null) {
                event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)be.get(), (blockEntity, dir) -> ((ContainerBlockEntity)((Object)blockEntity)).getItemHandlerOnSide((Direction)dir));
            }
            if (containerBE.getFluidHandler() != null) {
                event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)be.get(), (blockEntity, dir) -> ((ContainerBlockEntity)((Object)blockEntity)).getFluidHandlerOnSide((Direction)dir));
            }
            if (containerBE.getBacteriaStorage() == null) continue;
            event.registerBlockEntity(NTCapabilities.BacteriaStorage.BLOCK, (BlockEntityType)be.get(), (blockEntity, ctx) -> ((ContainerBlockEntity)((Object)blockEntity)).getBacteriaStorage());
        }
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

