/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.event;

import cy.jdkdigital.utilitarian.Config;
import cy.jdkdigital.utilitarian.client.render.block.NoSolicitingBannerRenderer;
import cy.jdkdigital.utilitarian.common.item.RestrainingOrder;
import cy.jdkdigital.utilitarian.common.item.TrowelItem;
import cy.jdkdigital.utilitarian.module.NoSolicitingModule;
import cy.jdkdigital.utilitarian.module.SnadModule;
import cy.jdkdigital.utilitarian.module.TPSMeterModule;
import cy.jdkdigital.utilitarian.module.UtilityBlockModule;
import cy.jdkdigital.utilitarian.module.UtilityItemModule;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

@EventBusSubscriber(modid="utilitarian", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientModEvents {
    @SubscribeEvent
    public static void tabContents(BuildCreativeModeTabContentsEvent event) {
        if (((Boolean)Config.NO_SOLICITING_ENABLED.get()).booleanValue()) {
            if (event.getTabKey().equals(CreativeModeTabs.TOOLS_AND_UTILITIES)) {
                event.accept((ItemLike)NoSolicitingModule.RESTRAINING_ORDER.get());
                event.accept((ItemLike)NoSolicitingModule.SOLICITING_CARPET_ITEM.get(DyeColor.WHITE).get());
                event.accept((ItemLike)NoSolicitingModule.TRAPPED_SOLICITING_CARPET_ITEM.get(DyeColor.WHITE).get());
                event.accept((ItemLike)UtilityBlockModule.FLUID_HOPPER_BLOCK.get());
                event.accept((ItemLike)UtilityBlockModule.ANGEL_BLOCK.get());
                event.accept((ItemLike)UtilityBlockModule.REDSTONE_CLOCK_BLOCK.get());
                event.accept((ItemLike)UtilityItemModule.TROWEL.get());
                event.accept((ItemLike)UtilityItemModule.TINY_COAL.get());
                event.accept((ItemLike)UtilityItemModule.TINY_CHARCOAL.get());
            }
            if (event.getTabKey().equals(CreativeModeTabs.COLORED_BLOCKS)) {
                for (DyeColor color : DyeColor.values()) {
                    event.accept((ItemLike)NoSolicitingModule.SOLICITING_CARPET_ITEM.get(color).get());
                    event.accept((ItemLike)NoSolicitingModule.TRAPPED_SOLICITING_CARPET_ITEM.get(color).get());
                }
            }
        }
        if (event.getTabKey().equals(CreativeModeTabs.REDSTONE_BLOCKS)) {
            event.accept((ItemLike)TPSMeterModule.TPS_METER_ITEM.get());
            event.accept((ItemLike)UtilityBlockModule.REDSTONE_CLOCK_BLOCK.get());
        }
        if (event.getTabKey().equals(CreativeModeTabs.FUNCTIONAL_BLOCKS)) {
            event.accept((ItemLike)UtilityBlockModule.ANGEL_BLOCK_ITEM.get());
            event.accept((ItemLike)TPSMeterModule.TPS_METER_ITEM.get());
            event.accept((ItemLike)SnadModule.SNAD_BLOCK_ITEM.get());
            event.accept((ItemLike)SnadModule.RED_SNAD_BLOCK_ITEM.get());
            event.accept((ItemLike)SnadModule.SOUL_SNAD_BLOCK_ITEM.get());
            event.accept((ItemLike)SnadModule.DRIT_BLOCK_ITEM.get());
            event.accept((ItemLike)SnadModule.GRRASS_BLOCK_ITEM.get());
        }
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)NoSolicitingModule.NO_SOLICITING_BANNER_BLOCK_ENTITY.get(), NoSolicitingBannerRenderer::new);
    }

    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)NoSolicitingModule.RESTRAINING_ORDER.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"active"), (stack, world, entity, i) -> RestrainingOrder.isActive(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)UtilityItemModule.TROWEL.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"extended"), (stack, world, entity, i) -> TrowelItem.isExtended(stack) ? 1.0f : 0.0f);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)SnadModule.GRRASS_BLOCK.get()), (RenderType)RenderType.cutoutMipped());
        });
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            BlockState blockstate = ((BlockItem)stack.getItem()).getBlock().defaultBlockState();
            return event.getBlockColors().getColor(blockstate, null, null, tintIndex);
        }, new ItemLike[]{(ItemLike)SnadModule.GRRASS_BLOCK.get()});
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((blockState, lightReader, pos, tintIndex) -> lightReader != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)lightReader, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0), new Block[]{(Block)SnadModule.GRRASS_BLOCK.get()});
    }
}

