/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.common.block;

import cy.jdkdigital.utilitarian.Config;
import cy.jdkdigital.utilitarian.module.SnadModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.SoulSandBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.TriState;

public class SoulSnadBlock
extends SoulSandBlock {
    public SoulSnadBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public TriState canSustainPlant(BlockState state, BlockGetter level, BlockPos soilPosition, Direction facing, BlockState plant) {
        return plant.is(SnadModule.SOUL_SAND_GROWABLES) ? TriState.TRUE : TriState.DEFAULT;
    }

    protected void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.randomTick(pState, pLevel, pPos, pRandom);
        this.tick(pState, pLevel, pPos, pRandom);
    }

    protected void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.tick(pState, pLevel, pPos, pRandom);
        BlockState aboveBlock = pLevel.getBlockState(pPos.above());
        if (aboveBlock.is(SnadModule.SOUL_SAND_GROWABLES)) {
            for (int u = 0; u < (Integer)Config.SNAD_GROWTH_MULTIPLIER.get(); ++u) {
                aboveBlock.randomTick(pLevel, pPos.above(), pRandom);
            }
        }
    }
}

