/*
 * Decompiled with CFR 0.152.
 */
package com.mystchonky.arsocultas.common.event;

import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.klikli_dev.occultism.common.entity.job.CrusherJob;
import com.klikli_dev.occultism.common.entity.job.SmelterJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.mystchonky.arsocultas.common.mob_jar.SpiritBehaviour;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber(modid="ars_ocultas")
public class OccultismEvents {
    @SubscribeEvent
    public static void crusherJob(CrusherJob.CrusherJobEvent event) {
        SpiritEntity spirit;
        BlockEntity blockEntity;
        Entity entity = event.getEntity();
        Level level = event.getEntity().level();
        if (entity instanceof SpiritEntity && (blockEntity = level.getBlockEntity((spirit = (SpiritEntity)entity).blockPosition())) instanceof MobJarTile) {
            MobJarTile jar = (MobJarTile)blockEntity;
            jar.dispatchBehavior(behavior -> {
                if (behavior instanceof SpiritBehaviour) {
                    SpiritBehaviour spiritBehaviour = (SpiritBehaviour)((Object)behavior);
                    ItemStack remainder = spiritBehaviour.tryItemNearbyTransfer(jar, level, event.getResult());
                    event.setResult(remainder);
                }
            });
        }
    }

    @SubscribeEvent
    public static void smelterJob(SmelterJob.SmelterJobEvent event) {
        SpiritEntity spirit;
        BlockEntity blockEntity;
        Entity entity = event.getEntity();
        Level level = event.getEntity().level();
        if (entity instanceof SpiritEntity && (blockEntity = level.getBlockEntity((spirit = (SpiritEntity)entity).blockPosition())) instanceof MobJarTile) {
            MobJarTile jar = (MobJarTile)blockEntity;
            jar.dispatchBehavior(behavior -> {
                if (behavior instanceof SpiritBehaviour) {
                    SpiritBehaviour spiritBehaviour = (SpiritBehaviour)((Object)behavior);
                    ItemStack remainder = spiritBehaviour.tryItemNearbyTransfer(jar, level, event.getResult());
                    event.setResult(remainder);
                }
            });
        }
    }
}

