/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.tweaks;

import com.blakebr0.cucumber.event.ScytheHarvestCropEvent;
import com.blakebr0.pickletweaks.config.ModConfigs;
import com.blakebr0.pickletweaks.lib.ModTooltips;
import java.util.ListIterator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public final class TweakToolBreaking {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBreakingBlock(PlayerEvent.BreakSpeed event) {
        if (!((Boolean)ModConfigs.ENABLE_TOOL_BREAKING_TWEAK.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (player.getAbilities().instabuild) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            return;
        }
        Item item = stack.getItem();
        if (stack.isDamageableItem() && TweakToolBreaking.isValidTool(item) && TweakToolBreaking.isBroken(stack)) {
            TweakToolBreaking.sendBrokenMessage(player, stack);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (!((Boolean)ModConfigs.ENABLE_TOOL_BREAKING_TWEAK.get()).booleanValue()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.getAbilities().instabuild) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            return;
        }
        Item item = stack.getItem();
        if (stack.isDamageableItem() && TweakToolBreaking.isValidTool(item) && TweakToolBreaking.isBroken(stack)) {
            TweakToolBreaking.sendBrokenMessage(player, stack);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onAttackEntity(AttackEntityEvent event) {
        Item item;
        if (!((Boolean)ModConfigs.ENABLE_TOOL_BREAKING_TWEAK.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (player.getAbilities().instabuild) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            return;
        }
        if (stack.isDamageableItem() && TweakToolBreaking.isValidTool(item = stack.getItem()) && TweakToolBreaking.isBroken(stack)) {
            TweakToolBreaking.sendBrokenMessage(player, stack);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!((Boolean)ModConfigs.ENABLE_TOOL_BREAKING_TWEAK.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (player.getAbilities().instabuild) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.isEmpty()) {
            return;
        }
        Item item = stack.getItem();
        if (stack.isDamageableItem() && (item instanceof ProjectileWeaponItem || item instanceof ShearsItem) && TweakToolBreaking.isBroken(stack)) {
            TweakToolBreaking.sendBrokenMessage(player, stack);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!((Boolean)ModConfigs.ENABLE_TOOL_BREAKING_TWEAK.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (player.getAbilities().instabuild) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.isEmpty()) {
            return;
        }
        Item item = stack.getItem();
        if (stack.isDamageableItem() && TweakToolBreaking.isValidTool(item) && TweakToolBreaking.isBroken(stack)) {
            TweakToolBreaking.sendBrokenMessage(player, stack);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!((Boolean)ModConfigs.ENABLE_TOOL_BREAKING_TWEAK.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (player.getAbilities().instabuild) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.isEmpty()) {
            return;
        }
        Item item = stack.getItem();
        if (stack.isDamageableItem() && item instanceof ShearsItem && TweakToolBreaking.isBroken(stack)) {
            TweakToolBreaking.sendBrokenMessage(player, stack);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onScytheHarvestCrop(ScytheHarvestCropEvent event) {
        if (!((Boolean)ModConfigs.ENABLE_TOOL_BREAKING_TWEAK.get()).booleanValue()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.getAbilities().instabuild) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.isEmpty()) {
            return;
        }
        if (stack.isDamageableItem() && TweakToolBreaking.isBroken(stack)) {
            TweakToolBreaking.sendBrokenMessage(player, stack);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemTooltip(ItemTooltipEvent event) {
        Item item;
        if (!((Boolean)ModConfigs.ENABLE_TOOL_BREAKING_TWEAK.get()).booleanValue()) {
            return;
        }
        ListIterator<MutableComponent> tooltip = event.getToolTip().listIterator();
        ItemStack stack = event.getItemStack();
        if (stack.isDamageableItem() && (TweakToolBreaking.isValidTool(item = stack.getItem()) || item instanceof ProjectileWeaponItem) && TweakToolBreaking.isBroken(stack)) {
            tooltip.next();
            tooltip.add(ModTooltips.BROKEN.color(ChatFormatting.RED).build());
        }
    }

    public static boolean isValidTool(Item item) {
        return item instanceof DiggerItem || item instanceof SwordItem || item instanceof ShearsItem;
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.getMaxDamage() > 2 && stack.getDamageValue() >= stack.getMaxDamage() - 2;
    }

    private static void sendBrokenMessage(Player player, ItemStack stack) {
        player.displayClientMessage((Component)ModTooltips.YOUR_ITEM_IS_BROKEN.args(new Object[]{stack.getHoverName()}).color(ChatFormatting.WHITE).build(), true);
    }
}

