/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.network.payload;

import com.blakebr0.pickletweaks.PickleTweaks;
import com.blakebr0.pickletweaks.feature.item.MagnetItem;
import com.blakebr0.pickletweaks.init.ModDataComponentTypes;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ToggleMagnetPayload(int slot) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ToggleMagnetPayload> TYPE = new CustomPacketPayload.Type(PickleTweaks.resource("toggle_magnet"));
    public static final StreamCodec<ByteBuf, ToggleMagnetPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ToggleMagnetPayload::slot, ToggleMagnetPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleServer(ToggleMagnetPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            ItemStack stack = ((Slot)player.containerMenu.slots.get(payload.slot)).getItem();
            Item item = stack.getItem();
            if (item instanceof MagnetItem) {
                Boolean enabled = (Boolean)stack.getOrDefault(ModDataComponentTypes.MAGNET_ACTIVE, (Object)false);
                stack.set(ModDataComponentTypes.MAGNET_ACTIVE, (Object)(enabled == false ? 1 : 0));
            }
        });
    }
}

