/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.pickletweaks.config.ModConfigs;
import com.blakebr0.pickletweaks.init.ModDataComponentTypes;
import com.blakebr0.pickletweaks.lib.ModTooltips;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class MagnetItem
extends BaseItem {
    public MagnetItem() {
        super(p -> p.stacksTo(1).component(ModDataComponentTypes.MAGNET_ACTIVE, (Object)false));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Boolean enabled = (Boolean)stack.getOrDefault(ModDataComponentTypes.MAGNET_ACTIVE, (Object)false);
        player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 0.5f, enabled != false ? 0.5f : 1.0f);
        stack.set(ModDataComponentTypes.MAGNET_ACTIVE, (Object)(enabled == false ? 1 : 0));
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public boolean isFoil(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponentTypes.MAGNET_ACTIVE, (Object)false);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag advanced) {
        if (((Boolean)stack.getOrDefault(ModDataComponentTypes.MAGNET_ACTIVE, (Object)false)).booleanValue()) {
            tooltip.add((Component)ModTooltips.ENABLED.build());
        } else {
            tooltip.add((Component)ModTooltips.DISABLED.build());
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        Boolean enabled = (Boolean)stack.getOrDefault(ModDataComponentTypes.MAGNET_ACTIVE, (Object)false);
        if (entity instanceof Player && enabled.booleanValue()) {
            double range = (Double)ModConfigs.MAGNET_RANGE.get();
            List items = level.getEntitiesOfClass(ItemEntity.class, entity.getBoundingBox().inflate(range));
            for (ItemEntity item : items) {
                Entity thrower;
                if (!item.isAlive() || item.getPersistentData().contains("PreventRemoteMovement") || (thrower = item.getOwner()) != null && thrower.getUUID().equals(entity.getUUID()) && item.hasPickUpDelay() || level.isClientSide()) continue;
                item.setNoPickUpDelay();
                item.setPos(entity.getX(), entity.getY(), entity.getZ());
            }
            List orbs = level.getEntitiesOfClass(ExperienceOrb.class, entity.getBoundingBox().inflate(range));
            for (ExperienceOrb orb : orbs) {
                if (level.isClientSide()) continue;
                orb.setPos(entity.getX(), entity.getY(), entity.getZ());
            }
        }
    }
}

