/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.lib.Tooltips;
import com.blakebr0.pickletweaks.lib.ModTooltips;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class EmeraldAppleItem
extends BaseItem {
    public static final FoodProperties FOOD = new FoodProperties.Builder().nutrition(10).saturationModifier(2.0f).alwaysEdible().build();

    public EmeraldAppleItem() {
        super(p -> p.food(FOOD).rarity(Rarity.EPIC));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        int duration = 0;
        MobEffectInstance potion = entity.getEffect(MobEffects.DAMAGE_BOOST);
        if (potion != null && potion.getAmplifier() >= 0) {
            duration = potion.getDuration();
        }
        entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, duration + 4800, 0));
        potion = entity.getEffect(MobEffects.REGENERATION);
        if (potion != null && potion.getAmplifier() >= 2) {
            duration = potion.getDuration();
        }
        entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, duration + 400, 2));
        potion = entity.getEffect(MobEffects.ABSORPTION);
        if (potion != null && potion.getAmplifier() >= 4) {
            duration = potion.getDuration();
        }
        entity.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, duration + 4800, 4));
        potion = entity.getEffect(MobEffects.FIRE_RESISTANCE);
        if (potion != null && potion.getAmplifier() >= 0) {
            duration = potion.getDuration();
        }
        entity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, duration + 4800, 0));
        potion = entity.getEffect(MobEffects.DAMAGE_RESISTANCE);
        if (potion != null && potion.getAmplifier() >= 1) {
            duration = potion.getDuration();
        }
        entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, duration + 4800, 1));
        return entity.eat(level, stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)ModTooltips.GIVES_BUFFS.build());
            tooltip.add(ModTooltips.createMobEffectLine((Holder<MobEffect>)MobEffects.DAMAGE_BOOST, "I", EmeraldAppleItem.getDuration(4800)));
            tooltip.add(ModTooltips.createMobEffectLine((Holder<MobEffect>)MobEffects.REGENERATION, "III", EmeraldAppleItem.getDuration(400)));
            tooltip.add(ModTooltips.createMobEffectLine((Holder<MobEffect>)MobEffects.ABSORPTION, "IV", EmeraldAppleItem.getDuration(4800)));
            tooltip.add(ModTooltips.createMobEffectLine((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE, "I", EmeraldAppleItem.getDuration(4800)));
            tooltip.add(ModTooltips.createMobEffectLine((Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE, "II", EmeraldAppleItem.getDuration(4800)));
        } else {
            tooltip.add((Component)Tooltips.HOLD_SHIFT_FOR_INFO.build());
        }
    }

    private static String getDuration(int ticks) {
        int duration = ticks / 20;
        int minutes = Math.floorDiv(duration, 60);
        String seconds = String.format("%02d", duration % 60);
        return minutes + ":" + seconds;
    }
}

