/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.crafting;

import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.pickletweaks.config.ModConfigs;
import com.blakebr0.pickletweaks.feature.crafting.GridRepairHelper;
import com.blakebr0.pickletweaks.init.ModRecipeSerializers;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class GridRepairRecipe
extends ShapelessRecipe {
    public GridRepairRecipe() {
        super("", CraftingBookCategory.EQUIPMENT, ItemStack.EMPTY, NonNullList.create());
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider lookup) {
        if (!((Boolean)ModConfigs.GRID_REPAIR_ENABLED.get()).booleanValue()) {
            return ItemStack.EMPTY;
        }
        ItemStack tool = ItemStack.EMPTY;
        NonNullList inputs = NonNullList.create();
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack slotStack = inventory.getItem(i);
            if (slotStack.isEmpty()) continue;
            if (tool.isEmpty() && slotStack.isDamageableItem()) {
                tool = slotStack;
                continue;
            }
            inputs.add((Object)slotStack);
        }
        if (tool.isEmpty() || !tool.isDamaged() || inputs.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (GridRepairHelper.isBlacklisted(tool.getItem())) {
            return ItemStack.EMPTY;
        }
        int repairCost = (Integer)ModConfigs.GRID_REPAIR_COST.get();
        int enchantmentCost = (Integer)ModConfigs.GRID_REPAIR_ENCHANTMENT_COST.get();
        boolean cheaperShovel = (Boolean)ModConfigs.GRID_REPAIR_CHEAP_SHOVEL.get();
        boolean cheaperShears = (Boolean)ModConfigs.GRID_REPAIR_CHEAP_SHEARS.get();
        if (cheaperShovel && tool.getItem() instanceof ShovelItem || cheaperShears && tool.getItem() instanceof ShearsItem) {
            repairCost = Math.max(1, repairCost / 2);
            enchantmentCost = Math.max(0, enchantmentCost / 2);
        }
        int damage = tool.getMaxDamage() / (repairCost + (tool.isEnchanted() ? enchantmentCost : 0));
        double matCount = 0.0;
        boolean maxed = false;
        for (ItemStack mat : inputs) {
            if (maxed) {
                return ItemStack.EMPTY;
            }
            if (!mat.hasCraftingRemainingItem()) {
                double matValue = GridRepairHelper.getMaterialValue(tool, mat);
                if (matValue == 0.0) {
                    return ItemStack.EMPTY;
                }
                matCount += matValue;
                if (!((double)tool.getDamageValue() - (double)damage * matCount <= 0.0)) continue;
                maxed = true;
                continue;
            }
            return ItemStack.EMPTY;
        }
        tool = StackHelper.withSize((ItemStack)tool, (int)1, (boolean)false);
        tool.setDamageValue(tool.getDamageValue() - (int)((double)damage * matCount));
        if (((Boolean)ModConfigs.GRID_REPAIR_STRIP_ENCHANTMENTS.get()).booleanValue()) {
            ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(tool.getTagEnchantments());
            enchantments.removeIf(e -> !GridRepairRecipe.isCurse((Enchantment)e.value()));
            EnchantmentHelper.setEnchantments((ItemStack)tool, (ItemEnchantments)enchantments.toImmutable());
        }
        return tool;
    }

    public boolean matches(CraftingInput inventory, Level level) {
        return !this.assemble(inventory, (HolderLookup.Provider)level.registryAccess()).isEmpty();
    }

    public ItemStack getResultItem(HolderLookup.Provider lookup) {
        return ItemStack.EMPTY;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.CRAFTING_GRID_REPAIR.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inventory) {
        return NonNullList.withSize((int)inventory.size(), (Object)ItemStack.EMPTY);
    }

    private static boolean isCurse(Enchantment enchantment) {
        return enchantment.effects().has(EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP) || enchantment.effects().has(EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE);
    }

    public static class Serializer
    implements RecipeSerializer<GridRepairRecipe> {
        private static final GridRepairRecipe INSTANCE = new GridRepairRecipe();
        public static final MapCodec<GridRepairRecipe> CODEC = MapCodec.unit((Object)((Object)INSTANCE)).stable();
        public static final StreamCodec<RegistryFriendlyByteBuf, GridRepairRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<GridRepairRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GridRepairRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static GridRepairRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            return new GridRepairRecipe();
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, GridRepairRecipe recipe) {
        }
    }
}

