/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.client.handler;

import com.blakebr0.pickletweaks.compat.curios.CuriosCompat;
import com.blakebr0.pickletweaks.config.ModConfigs;
import com.blakebr0.pickletweaks.feature.item.NightVisionGogglesItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public final class NightVisionGogglesHandler {
    public static final List<String> WEARERS = new ArrayList<String>();

    public static String getPlayerKey(Player player) {
        return player.getGameProfile().getName() + ":" + player.isLocalPlayer();
    }

    public static boolean hasGoggles(Player player) {
        ItemStack stack = player.getItemBySlot(EquipmentSlot.HEAD);
        return !stack.isEmpty() && stack.getItem() instanceof NightVisionGogglesItem || ModConfigs.isCuriosInstalled() && CuriosCompat.findNightVisionGogglesCurio((LivingEntity)player).isPresent();
    }

    @SubscribeEvent
    public void onLivingTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        String key = NightVisionGogglesHandler.getPlayerKey(player);
        boolean hasGoggles = NightVisionGogglesHandler.hasGoggles(player);
        if (WEARERS.contains(key)) {
            if (hasGoggles) {
                player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 246, 0, true, false));
            } else {
                player.removeEffectNoUpdate(MobEffects.NIGHT_VISION);
                WEARERS.remove(key);
            }
        } else if (hasGoggles) {
            WEARERS.add(key);
        }
    }
}

