/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.compat.curios;

import com.blakebr0.pickletweaks.compat.curios.curio.MagnetCurio;
import com.blakebr0.pickletweaks.compat.curios.curio.NightVisionGogglesCurio;
import com.blakebr0.pickletweaks.init.ModItems;
import java.util.Optional;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotResult;

public final class CuriosCompat {
    public static Optional<ItemStack> findNightVisionGogglesCurio(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(inventory -> inventory.findFirstCurio(stack -> stack.is((Item)ModItems.NIGHT_VISION_GOGGLES.get()) || stack.is((Item)ModItems.REINFORCED_NIGHT_VISION_GOGGLES.get())).map(SlotResult::stack));
    }

    public static Optional<ItemStack> findMagnetCurio(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(inventory -> inventory.findFirstCurio((Item)ModItems.MAGNET.get()).map(SlotResult::stack));
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(CuriosCapability.ITEM, (stack, unused) -> new MagnetCurio((ItemStack)stack), new ItemLike[]{(ItemLike)ModItems.MAGNET.get()});
        event.registerItem(CuriosCapability.ITEM, (stack, unused) -> new NightVisionGogglesCurio((ItemStack)stack), new ItemLike[]{(ItemLike)ModItems.NIGHT_VISION_GOGGLES.get(), (ItemLike)ModItems.REINFORCED_NIGHT_VISION_GOGGLES.get()});
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CuriosCompat.findNightVisionGogglesCurio((LivingEntity)player).ifPresent(stack -> stack.hurtAndBreak(1, entity, EquipmentSlot.HEAD));
        }
    }
}

