/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.callback.type;

import com.google.gson.annotations.SerializedName;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ModalPanel;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import net.rocketplatform.game.client.mod.ui.widget.MultilineStringWidget;
import org.jetbrains.annotations.Nullable;

public class ConfirmationCallback
extends ElementCallback {
    private Component prompt;
    @SerializedName(value="on_accept")
    private ElementCallback onAccept;
    @SerializedName(value="on_decline")
    private ElementCallback onDecline;

    public ConfirmationCallback(String action) {
        super(action);
    }

    @Override
    public void onPress(TemplateScreen screen, @Nullable CallbackHolder holder, VariableStorage variableStorage) {
        BaseScreen baseScreen;
        Screen screen2 = Minecraft.getInstance().screen;
        if (screen2 instanceof ScreenWrapper) {
            ScreenWrapper wrapper = (ScreenWrapper)screen2;
            v0 = wrapper.getGui();
        } else {
            v0 = baseScreen = null;
        }
        if (baseScreen == null) {
            if (screen instanceof BaseScreen) {
                BaseScreen base;
                baseScreen = base = (BaseScreen)screen;
            } else {
                RocketClientMod.getLogger().error("Unable to find BaseScreen for ConfirmationCallback. Screen was a {}", (Object)screen);
                return;
            }
        }
        Component replacedText = VariableProcessor.processComponent(this.prompt, variableStorage);
        ConfirmationPanel panel = new ConfirmationPanel((Panel)baseScreen, replacedText, () -> {
            if (this.onAccept != null) {
                this.onAccept.onPress(screen, holder, variableStorage);
            }
        }, () -> {
            if (this.onDecline != null) {
                this.onDecline.onPress(screen, holder, variableStorage);
            }
        });
        panel.setPosAndSize(baseScreen.width / 2 - 100, baseScreen.height / 2 - 50, 200, 100);
        baseScreen.pushModalPanel((ModalPanel)panel);
    }

    private static class ConfirmationPanel
    extends ModalPanel {
        private final TextBoxPanel textBoxPanel = new TextBoxPanel();
        private final MultilineStringWidget textBox;
        private final Button accept;
        private final Button cancel;
        private final Runnable onAccept;
        private final Runnable onDecline;

        public ConfirmationPanel(Panel panel, Component prompt, Runnable onAccept, Runnable onDecline) {
            super(panel);
            this.textBox = new MultilineStringWidget(this.textBoxPanel, prompt);
            this.accept = SimpleTextButton.create((Panel)this, (Component)Component.translatable((String)"gui.yes"), (Icon)Icons.ACCEPT, this::onAccepted, (Component[])new Component[0]);
            this.cancel = SimpleTextButton.create((Panel)this, (Component)Component.translatable((String)"gui.back"), (Icon)Icons.CANCEL, this::onCancelled, (Component[])new Component[0]);
            this.onAccept = onAccept;
            this.onDecline = onDecline;
        }

        public void addWidgets() {
            this.add((Widget)this.textBoxPanel);
            this.add((Widget)this.accept);
            this.add((Widget)this.cancel);
        }

        public void alignWidgets() {
            this.textBox.setMaxWidth(this.width - 8);
            this.textBoxPanel.setPosAndSize(4, 4, this.width - 8, this.height - 32);
            this.textBoxPanel.addWidgets();
            this.textBoxPanel.alignWidgets();
            this.accept.setPosAndSize(5, 74, 90, 20);
            this.cancel.setPosAndSize(105, 74, 90, 20);
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            theme.drawContextMenuBackground(graphics, x, y, w, h);
        }

        private void onAccepted(MouseButton mb) {
            try {
                this.onAccept.run();
            }
            catch (Throwable t) {
                RocketClientMod.getLogger().error("Error while running onAccept callback", t);
            }
            this.playClickSound();
            this.getGui().popModalPanel();
        }

        private void onCancelled(MouseButton mb) {
            try {
                this.onDecline.run();
            }
            catch (Throwable t) {
                RocketClientMod.getLogger().error("Error while running onDecline callback", t);
            }
            this.playClickSound();
            this.getGui().popModalPanel();
        }

        public boolean keyPressed(Key key) {
            if (key.esc()) {
                this.onCancelled(MouseButton.LEFT);
                return true;
            }
            return super.keyPressed(key);
        }

        private class TextBoxPanel
        extends Panel {
            public TextBoxPanel() {
                super((Panel)ConfirmationPanel.this);
            }

            public void addWidgets() {
                this.add(ConfirmationPanel.this.textBox);
            }

            public void alignWidgets() {
                ConfirmationPanel.this.textBox.setSize(this.width, this.height);
                this.setScrollY(0.0);
            }

            public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            }
        }
    }
}

