/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelpreview;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.creeperhost.levelio.data.Block;
import net.creeperhost.levelio.data.Chunk;
import net.creeperhost.levelio.data.Level;
import net.creeperhost.levelio.data.Region;
import net.creeperhost.levelio.lib.BlockPos;
import net.creeperhost.levelio.lib.ChunkPos;
import net.creeperhost.levelpreview.ColourMap;
import net.creeperhost.levelpreview.lib.CaptureArea;
import net.creeperhost.levelpreview.lib.SimplePNG;
import net.creeperhost.levelpreview.lib.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptureHandler {
    public static final int UNKNOWN_BLOCK_MARKER = -150994944;
    public static final int UNKNOWN_BLOCK_COLOUR = -65281;
    private static final Logger LOGGER = LoggerFactory.getLogger(CaptureHandler.class);
    private static ExecutorService CAPTURE_EXECUTOR;

    public static void init(int captureThreads) {
        CAPTURE_EXECUTOR = Executors.newFixedThreadPool(captureThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Capture Thread").build());
    }

    public static CaptureData capture(ColourMap colourMap, Level level, CaptureArea area, boolean heatMap) {
        int xSize = area.maxPos.x - area.minPos.x;
        int zSize = area.maxPos.z - area.minPos.z;
        CaptureData data = new CaptureData(xSize, zSize, heatMap);
        ChunkPos minChunk = area.minPos.toChunkPos();
        ChunkPos maxChunk = area.maxPos.toChunkPos();
        double maxHab = heatMap ? area.chunksTime.values().stream().mapToDouble(e -> e).max().orElse(1.0) : 1.0;
        HashMap<Region, List> captureTasks = new HashMap<Region, List>();
        for (int chunkX = minChunk.x; chunkX <= maxChunk.x; ++chunkX) {
            for (int chunkZ = minChunk.z; chunkZ <= maxChunk.z; ++chunkZ) {
                ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
                Region region2 = level.getRegions().get(chunkPos.toRegionPos());
                if (region2 == null) continue;
                captureTasks.computeIfAbsent(region2, e -> new ArrayList()).add(() -> CaptureHandler.captureChunk(colourMap, maxHab, chunkPos, region2, area, data, heatMap));
            }
        }
        ArrayList activeTasks = new ArrayList();
        captureTasks.forEach((region, tasks) -> activeTasks.add(CAPTURE_EXECUTOR.submit(() -> tasks.forEach(Runnable::run))));
        Utils.waitForTasks(activeTasks);
        return data;
    }

    private static void captureChunk(ColourMap colourMap, double maxHab, ChunkPos chunkPos, Region region, CaptureArea area, CaptureData data, boolean heatMap) {
        Chunk chunk;
        try {
            chunk = region.loadChunk(chunkPos);
        }
        catch (IOException e) {
            LOGGER.warn("An error occurred while attempting to load chunk at {}", (Object)chunkPos, (Object)e);
            return;
        }
        int heat = 0;
        if (heatMap) {
            double val = area.chunksTime.getOrDefault(chunkPos, 0.0) / maxHab;
            val = -val + 1.0;
            val = 1.0 - val * val * val;
            heat = (int)(val * 255.0);
        }
        if (chunk == null) {
            return;
        }
        BlockPos pos = new BlockPos(0, 0, 0);
        BlockPos origin = area.minPos;
        int xSize = area.maxPos.x - area.minPos.x;
        int zSize = area.maxPos.z - area.minPos.z;
        for (int x = 0; x < 16; ++x) {
            int xPos = (chunkPos.x << 4) + x;
            if (xPos < origin.x || xPos >= origin.x + xSize) continue;
            for (int z = 0; z < 16; ++z) {
                int zPos = (chunkPos.z << 4) + z;
                if (zPos < origin.z || zPos >= origin.z + zSize) continue;
                pos.set(xPos, 0, zPos);
                BlockPos topPos = chunk.getTopBlock(pos, block -> !block.isAir() && colourMap.getBlockColour((Block)block, 0) != -16777216);
                if (topPos == null) {
                    data.set(xPos - origin.x, zPos - origin.z, 0, 0);
                } else {
                    Block block2 = chunk.getBlock(topPos);
                    int colour = colourMap.getBlockColour(block2, -150994944);
                    int blockHeight = block2 == null ? 0 : topPos.y;
                    data.set(xPos - origin.x, zPos - origin.z, colour, blockHeight);
                }
                if (!heatMap) continue;
                data.setHeat(xPos - origin.x, zPos - origin.z, heat);
            }
        }
        region.unloadChunk(chunk.pos);
    }

    public static class CaptureData {
        private final int width;
        private final int height;
        public int[] colour;
        public int[] yLevel;
        public byte[] habHeatMap;

        public CaptureData(int width, int height, boolean heat) {
            this.width = width;
            this.height = height;
            this.colour = new int[width * height];
            this.yLevel = new int[width * height];
            if (heat) {
                this.habHeatMap = new byte[width * height];
            }
        }

        public synchronized void set(int x, int y, int colour, int yLevel) {
            int i = y * this.width + x;
            this.colour[i] = colour;
            this.yLevel[i] = yLevel;
        }

        public synchronized void setHeat(int x, int y, int heat) {
            int i = y * this.width + x;
            this.habHeatMap[i] = (byte)heat;
        }

        public int getColour(int x, int y) {
            int i = y * this.width + x;
            return this.colour[i];
        }

        public int getYLevel(int x, int y) {
            int i = y * this.width + x;
            return this.yLevel[i];
        }

        public int getHeat(int x, int y) {
            int i = y * this.width + x;
            return this.habHeatMap[i] & 0xFF;
        }

        public SimplePNG.SimpleImg generateImage(boolean topography, boolean heatMap, boolean heatOnly) {
            SimplePNG.SimpleImg image = new SimplePNG.SimpleImg(this.width, this.height);
            for (int x = 0; x < this.width; ++x) {
                double lastHeight = 0.0;
                for (int y = 0; y < this.height; ++y) {
                    float value;
                    int i = y * this.width + x;
                    if (heatOnly) {
                        int heat = this.habHeatMap[i] & 0xFF;
                        image.set(x, y, 0xFF0000 | heat << 24);
                        continue;
                    }
                    int col = this.colour[i];
                    if (col == -150994944) {
                        col = -65281;
                    } else if (topography) {
                        int height = this.yLevel[i];
                        ColourMap.Brightness brightness = (double)height > lastHeight ? ColourMap.Brightness.HIGH : ((double)height < lastHeight ? ColourMap.Brightness.LOW : ColourMap.Brightness.NORMAL);
                        lastHeight = height;
                        col = brightness.apply(col);
                    }
                    if (heatMap && (x & 1) == 0 != ((y & 1) == 0) && (value = (float)(this.habHeatMap[i] & 0xFF) / 255.0f) > 0.0f) {
                        if ((col >> 24 & 0xFF) == 0) {
                            col = 0xFF000000 | (this.habHeatMap[i] & 0xFF) << 16;
                        } else {
                            float red = (float)(col >> 16 & 0xFF) / 255.0f;
                            float green = (float)(col >> 8 & 0xFF) / 255.0f;
                            float blue = (float)(col & 0xFF) / 255.0f;
                            red = (1.0f - value) * red + value * 1.0f;
                            green = (1.0f - value) * green + value * 0.0f;
                            blue = (1.0f - value) * blue + value * 0.0f;
                            col = col | 0xFF000000 | (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f);
                        }
                    }
                    image.set(x, y, col);
                }
            }
            return image;
        }
    }
}

