/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelpreview;

import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.collection.FastStream;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.util.SneakyUtils;
import net.creeperhost.levelio.LevelIO;
import net.creeperhost.levelio.data.Chunk;
import net.creeperhost.levelio.data.Level;
import net.creeperhost.levelio.data.Player;
import net.creeperhost.levelio.data.Region;
import net.creeperhost.levelio.lib.BlockPos;
import net.creeperhost.levelio.lib.ChunkPos;
import net.creeperhost.levelio.lib.MCAFile;
import net.creeperhost.levelio.lib.Vec3;
import net.creeperhost.levelio.loader.LevelType;
import net.creeperhost.levelpreview.LevelPreview;
import net.creeperhost.levelpreview.lib.CaptureArea;
import net.creeperhost.levelpreview.lib.Cluster;
import net.creeperhost.levelpreview.lib.NBTQuickSearch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivityScanner.class);
    public static final double CLUSTER_TIME_WEIGHT = 1.5;
    public static final double CLUSTER_SIZE_WEIGHT = 0.5;
    public static final double CHUNK_VALID_TH = 0.05;
    public static final double TIME_CONVERSION = 72000.0;
    public static final double CLUSTER_START_TH = 0.1;
    private final LevelIO levelIO;
    private final Level level;
    private Region fallbackRegion = null;
    private List<CaptureArea> results = new ArrayList<CaptureArea>();
    private double totalHabitationFactor = 0.0;
    private ExecutorService SCAN_EXECUTOR;

    public ActivityScanner(LevelIO levelIO, Level level, int scanThreads) {
        this.levelIO = levelIO;
        this.level = level;
        this.SCAN_EXECUTOR = Executors.newFixedThreadPool(scanThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Scan Thread").build());
    }

    public List<CaptureArea> getResults() {
        return this.results;
    }

    public double getTotalHabitationFactor() {
        return this.totalHabitationFactor;
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean findActivityClusters(int minSize, int maxSize, int maxClusters) {
        if (maxClusters < 1) {
            throw new IllegalArgumentException("Max clusters must be at least 1");
        }
        long startms = System.currentTimeMillis();
        LevelPreview.debug("Scanning Level {}", this.level.levelInfo.identifier);
        this.results.clear();
        Map<ChunkPos, Long> map = this.generateHabitationMap();
        double hours = FastStream.of(map.values()).map(e -> (double)e.longValue() / 20.0).doubleSum(value -> value) / 60.0 / 60.0;
        hours = (double)Math.round(hours * 100.0) / 100.0;
        LevelPreview.debug("Took {}ms to find {} habited chunks for level {}, Total Hab Hours: {}h", System.currentTimeMillis() - startms, map.size(), this.level.levelInfo.identifier, hours);
        startms = System.currentTimeMillis();
        if (this.fallbackRegion != null) {
            int size = Math.min(Math.max(512, minSize), maxSize);
            BlockPos resultMin = new BlockPos((this.fallbackRegion.pos.x << 5) + 256, 0, (this.fallbackRegion.pos.z << 5) + 256);
            resultMin.x -= size / 2;
            resultMin.z -= size / 2;
            BlockPos resultMax = resultMin.copy().offset(size, 0, size);
            this.results.add(new CaptureArea(this.level, resultMin, resultMax));
            this.fallbackRegion = null;
            return true;
        }
        if (map.isEmpty()) {
            return false;
        }
        List<Cluster> clusters = this.findClusters(map, minSize, maxSize, maxClusters);
        LevelPreview.debug("Took {}ms to find {} clusters in level {}", System.currentTimeMillis() - startms, clusters.size(), this.level.levelInfo.identifier);
        startms = System.currentTimeMillis();
        double avgClusterTime = FastStream.of(clusters).map(e -> e.totalHabTime).doubleSum(e -> e) / (double)clusters.size();
        double avgClusterSize = (double)FastStream.of(clusters).map(e -> e.diameter).intSum(e -> e) / (double)clusters.size();
        clusters.sort(Comparator.comparingDouble(e -> e.getClusterWeight(avgClusterSize, avgClusterTime)).reversed());
        for (Cluster cluster : clusters) {
            this.results.add(cluster.trimAndFinish(minSize, maxSize));
        }
        LevelPreview.debug("Took {}ms to compile {} results for level {}", System.currentTimeMillis() - startms, this.results.size(), this.level.levelInfo.identifier);
        return true;
    }

    private List<Cluster> findClusters(Map<ChunkPos, Long> habMap, int minSize, int maxSize, int maxClusters) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        double totalAvgClusterTime = 0.0;
        while (!habMap.isEmpty() && clusters.size() < maxClusters) {
            ChunkPos start = (ChunkPos)habMap.entrySet().stream().max(Comparator.comparingLong(Map.Entry::getValue)).get().getKey();
            Cluster cluster = new Cluster(start, this.level);
            double totalHabTime = (double)habMap.remove(start).longValue() / 72000.0;
            int clusterMatches = 1;
            cluster.chunks.put(start, totalHabTime);
            if (totalAvgClusterTime > 0.0 && totalHabTime < totalAvgClusterTime * 0.1) break;
            int searchRad = 1;
            while (searchRad * 16 <= maxSize) {
                boolean foundValid = false;
                for (int i = -searchRad; i <= searchRad; ++i) {
                    for (int side = 0; side < 4; ++side) {
                        boolean valid;
                        int z;
                        if (side > 1 && (i == -searchRad || i == searchRad)) continue;
                        int x = start.x + (side < 2 ? i : (side < 3 ? -searchRad : searchRad));
                        ChunkPos pos = new ChunkPos(x, z = start.z + (side > 1 ? i : (side == 0 ? -searchRad : searchRad)));
                        if (!habMap.containsKey(pos)) continue;
                        double hab = (double)habMap.remove(pos).longValue() / 72000.0;
                        cluster.chunks.put(pos, hab);
                        boolean bl = valid = searchRad <= 3 || hab >= totalHabTime / (double)clusterMatches * 0.05;
                        if (!valid) continue;
                        foundValid = true;
                        ++clusterMatches;
                        totalHabTime += hab;
                    }
                }
                if (!foundValid && searchRad * 16 * 2 > minSize) break;
                ++searchRad;
            }
            totalAvgClusterTime += totalHabTime / (double)clusterMatches;
            clusters.add(cluster.finalize(searchRad));
        }
        return clusters;
    }

    public Map<ChunkPos, Long> generateHabitationMap() {
        this.fallbackRegion = null;
        this.totalHabitationFactor = 0.0;
        LevelPreview.debug("Generating Habitation map for level {}", this.level.levelInfo.identifier);
        Map<ChunkPos, Region> regionMap = this.level.getRegions();
        if (regionMap.isEmpty()) {
            LevelPreview.debug("Level is empty, skipping...", new Object[0]);
            return Collections.emptyMap();
        }
        int pre161 = this.checkIfPre161(regionMap);
        if (pre161 != 0) {
            return pre161 == -1 ? Collections.emptyMap() : this.pre161HabitationFallback();
        }
        HashSet<ChunkPos> startChunks = new HashSet<ChunkPos>();
        Collection<Player> players = this.levelIO.getPlayers().values();
        if (this.level.levelInfo.type == LevelType.OVERWORLD) {
            startChunks.add(this.levelIO.saveInfo.getWorldSpawn().toChunkPos());
            for (Player player : players) {
                BlockPos spawn = player.getSpawnPos();
                if (spawn == null) continue;
                startChunks.add(spawn.toChunkPos());
            }
        }
        for (Player player : players) {
            Vec3 pos = player.getPos();
            if (pos == null || !this.level.levelInfo.identifier.equals(player.getDimension(this.levelIO.saveInfo))) continue;
            startChunks.add(pos.toPos().toChunkPos());
        }
        this.fallbackRegion = this.findStartChunks(startChunks);
        if (this.fallbackRegion != null) {
            return Collections.emptyMap();
        }
        return this.doFloodSearch(startChunks);
    }

    private int checkIfPre161(Map<ChunkPos, Region> regionMap) {
        Chunk chunk = null;
        for (Region region : regionMap.values()) {
            MCAFile mca = region.getRegionMCA();
            Map<ChunkPos, Long> chunkMap = mca.getPopulatedChunks(region.pos);
            if (chunkMap.isEmpty()) continue;
            ChunkPos pos = (ChunkPos)Iterables.get(chunkMap.keySet(), (int)0);
            try {
                chunk = region.loadChunk(pos);
                break;
            }
            catch (IOException e) {
                LOGGER.warn("Failed to load chunk at pos {} in level {}", (Object)pos, (Object)this.level.levelInfo.identifier);
            }
        }
        if (chunk == null) {
            LOGGER.error("No populated chunks found in level {}, Skipping Level...", (Object)this.level.levelInfo.identifier);
            return -1;
        }
        boolean pre161 = chunk.inhabitedTime == -1L;
        chunk.region.unloadChunk(chunk.pos);
        if (pre161) {
            LOGGER.info("Level is pre 1.6.1, using fallback logic");
        }
        return pre161 ? 1 : 0;
    }

    private Region verifyStartChunks(Set<ChunkPos> startChunks) {
        for (ChunkPos startChunk : startChunks) {
            if (this.getHabTime(startChunk) <= 0L) continue;
            return null;
        }
        ArrayList<Region> regions = new ArrayList<Region>(this.level.getRegions().values());
        regions.sort(Comparator.comparingLong(Region::getFileSize).reversed());
        for (Region region : regions) {
            MCAFile mca = region.getRegionMCA();
            Map<ChunkPos, Long> chunkMap = mca.getPopulatedChunks(region.pos);
            for (ChunkPos pos : chunkMap.keySet()) {
                if (this.getHabTime(pos) <= 0L) continue;
                startChunks.add(pos);
                return null;
            }
        }
        LOGGER.warn("Could not find any player visited chinks id level {}, Will default to capturing largest region.", (Object)this.level.levelInfo.identifier);
        return (Region)regions.get(0);
    }

    private Region findStartChunks(Set<ChunkPos> startChunks) {
        ArrayList<Region> regions = new ArrayList<Region>(this.level.getRegions().values());
        regions.sort(Comparator.comparingLong(Region::getFileSize).reversed());
        block0: for (Region region : regions) {
            ChunkPos pos;
            int i;
            MCAFile mca = region.getRegionMCA();
            Map<ChunkPos, Long> chunkMap = mca.getPopulatedChunks(region.pos);
            int rx = region.pos.x << 5;
            int rz = region.pos.z << 5;
            for (i = 1; i < 31; ++i) {
                pos = new ChunkPos(rx + i, rz + i);
                if (chunkMap.containsKey(pos) && this.getHabTime(pos) > 0L) {
                    startChunks.add(pos);
                    break;
                }
                pos = new ChunkPos(rx + i, rz + 31 - i);
                if (!chunkMap.containsKey(pos) || this.getHabTime(pos) <= 0L) continue;
                startChunks.add(pos);
                break;
            }
            for (i = 0; i < 64 && (region.pos.x & 1) == 0 == ((region.pos.z & 1) == 0); ++i) {
                pos = new ChunkPos(rx + (i % 2 & 0x1F), rz + i / 2);
                if (chunkMap.containsKey(pos) && this.getHabTime(pos) > 0L) {
                    startChunks.add(pos);
                    continue block0;
                }
                if (i / 2 == 0 || i / 2 == 31 || !chunkMap.containsKey(pos = new ChunkPos(rx + i / 2, rz + (i % 2 & 0x1F))) || this.getHabTime(pos) <= 0L) continue;
                startChunks.add(pos);
                continue block0;
            }
        }
        if (startChunks.size() > 0) {
            return null;
        }
        LOGGER.warn("Could not find any player visited chinks id level {}, Will default to capturing largest region.", (Object)this.level.levelInfo.identifier);
        return (Region)regions.get(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getHabTime(ChunkPos pos) {
        Region region = this.level.getRegions().get(pos.toRegionPos());
        if (region == null) {
            return 0L;
        }
        MCAFile mca = region.getRegionMCA();
        try (NBTQuickSearch search = NBTQuickSearch.fromChunk(mca.getChunkBuffer(pos));){
            if (search == null || !search.findTag("InhabitedTime")) {
                long l2 = 0L;
                return l2;
            }
            long l = search.readLong();
            return l;
        }
        catch (IOException e) {
            LOGGER.error("An error occurred loading chunk {} in level {}", (Object)pos, (Object)this.level.levelInfo.identifier);
            return 0L;
        }
    }

    private Map<ChunkPos, Long> pre161HabitationFallback() {
        HashMap<ChunkPos, Long> chunkInhabitTime = new HashMap<ChunkPos, Long>();
        long currentUTCSeconds = System.currentTimeMillis() / 1000L;
        for (Region region : this.level.getRegions().values()) {
            MCAFile mca = region.getRegionMCA();
            Map<ChunkPos, Long> chunkMap = mca.getPopulatedChunks(region.pos);
            chunkMap.forEach((pos, lastModified) -> chunkInhabitTime.put((ChunkPos)pos, lastModified - currentUTCSeconds));
        }
        return chunkInhabitTime;
    }

    private Map<ChunkPos, Long> doFloodSearch(Collection<ChunkPos> startChunks) {
        boolean searchComplete;
        boolean threaded = true;
        if (!threaded) {
            HashMap<ChunkPos, Long> results = new HashMap<ChunkPos, Long>();
            for (ChunkPos startChunk : startChunks) {
                results.put(startChunk, this.getHabTime(startChunk));
            }
            LinkedList<ChunkPos> searchList = new LinkedList<ChunkPos>(startChunks);
            HashSet<ChunkPos> searched = new HashSet<ChunkPos>();
            while (!searchList.isEmpty()) {
                ChunkPos next = searchList.pollFirst();
                this.checkAroundPos(next, searchList, searched, results);
            }
            return results;
        }
        HashMap<ChunkPos, RegionSearchTask> taskMap = new HashMap<ChunkPos, RegionSearchTask>();
        ArrayList<Future<RegionSearchTask>> activeTasks = new ArrayList<Future<RegionSearchTask>>();
        for (ChunkPos pos : startChunks) {
            Region region = this.level.getRegions().get(pos.toRegionPos());
            if (region == null) continue;
            taskMap.computeIfAbsent(region.pos, e -> new RegionSearchTask(region)).addSearchChunk(pos);
        }
        do {
            searchComplete = true;
            for (RegionSearchTask task2 : taskMap.values()) {
                if (task2.searchComplete) continue;
                activeTasks.add(this.SCAN_EXECUTOR.submit(task2));
            }
            boolean waiting = true;
            while (waiting) {
                waiting = false;
                for (Future future : activeTasks) {
                    waiting |= !future.isDone();
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            for (Future future : activeTasks) {
                RegionSearchTask task4 = SneakyUtils.sneaky(() -> (RegionSearchTask)activeTask.get());
                for (ChunkPos pos : task4.adjacent) {
                    Region region = this.level.getRegions().get(pos.toRegionPos());
                    if (region == null) continue;
                    taskMap.computeIfAbsent(region.pos, e -> new RegionSearchTask(region)).addSearchChunk(pos);
                    searchComplete = false;
                }
                task4.adjacent.clear();
            }
            activeTasks.clear();
        } while (!searchComplete);
        HashMap<ChunkPos, Long> results = new HashMap<ChunkPos, Long>();
        taskMap.values().forEach(task -> results.putAll(task.results));
        return results;
    }

    private void checkAroundPos(ChunkPos pos, LinkedList<ChunkPos> toSearch, Set<ChunkPos> searched, Map<ChunkPos, Long> results) {
        searched.add(pos);
        for (int x = -1; x <= 1; x += 2) {
            for (int z = -1; z <= 1; z += 2) {
                ChunkPos search = new ChunkPos(pos.x + x, pos.z + z);
                if (searched.contains(search)) continue;
                long hab = this.getHabTime(search);
                if (hab > 0L) {
                    this.totalHabitationFactor += (double)hab / 72000.0;
                    results.put(search, hab);
                    toSearch.add(search);
                }
                searched.add(search);
            }
        }
    }

    public static void test(Level level) throws IOException {
        LOGGER.info("Scanning Level {}", (Object)level.levelInfo.identifier);
        HashMap<ChunkPos, Long> chunkInhabitTime = new HashMap<ChunkPos, Long>();
        for (Region region : level.getRegions().values()) {
            MCAFile mca = region.getRegionMCA();
            Map<ChunkPos, Long> chunkMap = mca.getPopulatedChunks(region.pos);
            for (ChunkPos pos : chunkMap.keySet()) {
                try {
                    NBTQuickSearch search = NBTQuickSearch.fromChunk(mca.getChunkBuffer(pos));
                    Throwable throwable = null;
                    try {
                        if (search == null) continue;
                        if (search.findTag("InhabitedTime")) {
                            long time = search.readLong();
                            chunkInhabitTime.put(pos, time);
                            continue;
                        }
                        chunkInhabitTime.put(pos, chunkMap.get(pos) - System.currentTimeMillis() / 1000L);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (search == null) continue;
                        if (throwable != null) {
                            try {
                                search.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        search.close();
                    }
                }
                catch (IOException e2) {
                    LOGGER.error("An error occurred loading chunk {} in level {}", (Object)pos, (Object)level.levelInfo.identifier);
                }
            }
        }
        double hours = FastStream.of(chunkInhabitTime.values()).map(e -> (double)e.longValue() / 20.0).doubleSum(value -> value) / 60.0 / 60.0;
        hours = (double)Math.round(hours * 100.0) / 100.0;
        LOGGER.info("Level {} has {} populated chunks, Total Hab Hours: {}h", new Object[]{level.levelInfo.identifier, chunkInhabitTime.size(), hours});
    }

    private static class RegionSearchTask
    implements Callable<RegionSearchTask> {
        private final Region region;
        private final MCAFile mca;
        private final ChunkPos regionMin;
        private final ChunkPos regionMax;
        public final LinkedList<ChunkPos> searchList = new LinkedList();
        public final Set<ChunkPos> searched = new HashSet<ChunkPos>();
        public final Map<ChunkPos, Long> results = new HashMap<ChunkPos, Long>();
        public final Set<ChunkPos> adjacent = new HashSet<ChunkPos>();
        public double habFactor = 0.0;
        public boolean searchComplete = false;

        public RegionSearchTask(Region region) {
            this.region = region;
            this.mca = region.getRegionMCA();
            int rx = region.pos.x << 5;
            int rz = region.pos.z << 5;
            this.regionMin = new ChunkPos(rx, rz);
            this.regionMax = new ChunkPos(rx + 31, rz + 31);
        }

        public void addSearchChunk(ChunkPos pos) {
            if (this.searched.contains(pos)) {
                return;
            }
            this.searchList.add(pos);
            this.searchComplete = false;
        }

        @Override
        public RegionSearchTask call() {
            ArrayList<ChunkPos> invalidStarts = new ArrayList<ChunkPos>();
            for (ChunkPos startChunk : this.searchList) {
                long time = this.getHabTime(startChunk);
                if (time > 0L) {
                    this.results.put(startChunk, time);
                    continue;
                }
                invalidStarts.add(startChunk);
            }
            this.searchList.removeAll(invalidStarts);
            while (!this.searchList.isEmpty()) {
                ChunkPos next = this.searchList.pollFirst();
                this.checkAroundPos(next);
            }
            return this;
        }

        private void checkAroundPos(ChunkPos pos) {
            this.searched.add(pos);
            for (int x = -1; x <= 1; x += 2) {
                for (int z = -1; z <= 1; z += 2) {
                    ChunkPos search = new ChunkPos(pos.x + x, pos.z + z);
                    if (this.searched.contains(search)) continue;
                    this.searched.add(search);
                    if (search.x < this.regionMin.x || search.z < this.regionMin.z || search.x > this.regionMax.x || search.z > this.regionMax.z) {
                        this.adjacent.add(search);
                        continue;
                    }
                    long hab = this.getHabTime(search);
                    if (hab <= 0L) continue;
                    this.habFactor += (double)hab / 72000.0;
                    this.results.put(search, hab);
                    this.searchList.add(search);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private long getHabTime(ChunkPos pos) {
            try (NBTQuickSearch search = NBTQuickSearch.fromChunk(this.mca.getChunkBuffer(pos));){
                if (search == null || !search.findTag("InhabitedTime")) {
                    long l2 = 0L;
                    return l2;
                }
                long l = search.readLong();
                return l;
            }
            catch (IOException e) {
                LOGGER.error("An error occurred loading chunk {} in level {}", (Object)pos, (Object)this.region.levelInfo.identifier);
                return 0L;
            }
        }
    }
}

