/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.loader;

import com.google.common.collect.ImmutableList;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.creeperhost.levelio.LevelIO;
import net.creeperhost.levelio.Utils;
import net.creeperhost.levelio.data.Level;
import net.creeperhost.levelio.loader.LevelInfo;
import net.creeperhost.levelio.loader.LevelType;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(LevelLoader.class);
    private final boolean readOnly;
    private Map<LevelInfo, Level> levelMap = new HashMap<LevelInfo, Level>();
    private Set<LevelType> loadedTypes = new HashSet<LevelType>();

    public LevelLoader(LevelIO levelIO, Path worldFolder, boolean readOnly) {
        this.readOnly = readOnly;
        if (Files.exists(worldFolder.resolve("region"), new LinkOption[0])) {
            this.addDimension(levelIO, worldFolder, LevelType.OVERWORLD, levelIO.saveInfo.hasDimNames() ? "minecraft:overworld" : "0");
        } else {
            LOGGER.warn("Could not locate region folder in specified world folder! Is there no overworld in this save???");
        }
        List<Path> folders = Utils.getFilesInFolder(worldFolder, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
        for (Path folder : folders) {
            String name = folder.getFileName().toString();
            if (name.startsWith("DIM")) {
                try {
                    int id = Integer.parseInt(name.substring(3));
                    this.addDimension(levelIO, folder, LevelType.fromDimId(id), LevelType.mapDimId(levelIO.saveInfo, id));
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Failed to get dimension id from {}", (Object)name, (Object)e);
                }
            }
            if (!name.equals("dimensions")) continue;
            List<Path> modFolders = Utils.getFilesInFolder(folder, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
            for (Path modFolder : modFolders) {
                String modid = modFolder.getFileName().toString();
                List<Path> modDims = Utils.getFilesInFolder(modFolder, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
                for (Path modDim : modDims) {
                    String dimName = modDim.getFileName().toString();
                    if (!Files.exists(modDim.resolve("region"), new LinkOption[0])) {
                        LOGGER.warn("Found possible mod dimension with no region folder {}:{}", (Object)modid, (Object)dimName);
                        continue;
                    }
                    this.addDimension(levelIO, modDim, LevelType.CUSTOM, modid + ":" + dimName);
                }
            }
        }
    }

    private void addDimension(LevelIO levelIO, Path path, LevelType type, String identifier) {
        if (type != LevelType.CUSTOM && this.loadedTypes.contains((Object)type)) {
            throw new IllegalStateException("Found duplicate vanilla dimension of type " + (Object)((Object)type));
        }
        this.loadedTypes.add(type);
        LevelInfo levelInfo = new LevelInfo(type, identifier, path);
        if (this.levelMap.containsKey(levelInfo)) {
            throw new IllegalStateException("Found duplicate dimension " + levelInfo);
        }
        this.levelMap.put(levelInfo, Level.create(levelIO, levelInfo, this.readOnly));
    }

    @Nullable
    public Level getLevel(LevelType type, @Nullable String identifier) {
        if (!this.loadedTypes.contains((Object)type)) {
            return null;
        }
        if (type == LevelType.CUSTOM && identifier == null) {
            return null;
        }
        for (LevelInfo levelInfo : this.levelMap.keySet()) {
            if (levelInfo.type != type) continue;
            if (type != LevelType.CUSTOM) {
                return this.levelMap.get(levelInfo);
            }
            if (!levelInfo.identifier.equals(identifier)) continue;
            return this.levelMap.get(levelInfo);
        }
        return null;
    }

    public List<Level> getLevels() {
        return ImmutableList.copyOf(this.levelMap.values());
    }

    public void close() {
        this.levelMap.values().forEach(Level::close);
    }
}

