/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.repack.org.quartz;

import net.creeperhost.ftbbackups.repack.org.quartz.CalendarIntervalTrigger;
import net.creeperhost.ftbbackups.repack.org.quartz.DateBuilder;
import net.creeperhost.ftbbackups.repack.org.quartz.ScheduleBuilder;
import net.creeperhost.ftbbackups.repack.org.quartz.impl.triggers.CalendarIntervalTriggerImpl;
import net.creeperhost.ftbbackups.repack.org.quartz.spi.MutableTrigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarIntervalScheduleBuilder
extends ScheduleBuilder<CalendarIntervalTrigger> {
    private int interval = 1;
    private DateBuilder.IntervalUnit intervalUnit = DateBuilder.IntervalUnit.DAY;
    private int misfireInstruction = 0;

    private CalendarIntervalScheduleBuilder() {
    }

    public static CalendarIntervalScheduleBuilder calendarIntervalSchedule() {
        return new CalendarIntervalScheduleBuilder();
    }

    @Override
    public MutableTrigger build() {
        CalendarIntervalTriggerImpl st = new CalendarIntervalTriggerImpl();
        st.setRepeatInterval(this.interval);
        st.setRepeatIntervalUnit(this.intervalUnit);
        st.setMisfireInstruction(this.misfireInstruction);
        return st;
    }

    public CalendarIntervalScheduleBuilder withInterval(int interval, DateBuilder.IntervalUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("TimeUnit must be specified.");
        }
        this.validateInterval(interval);
        this.interval = interval;
        this.intervalUnit = unit;
        return this;
    }

    public CalendarIntervalScheduleBuilder withIntervalInSeconds(int intervalInSeconds) {
        this.validateInterval(intervalInSeconds);
        this.interval = intervalInSeconds;
        this.intervalUnit = DateBuilder.IntervalUnit.SECOND;
        return this;
    }

    public CalendarIntervalScheduleBuilder withIntervalInMinutes(int intervalInMinutes) {
        this.validateInterval(intervalInMinutes);
        this.interval = intervalInMinutes;
        this.intervalUnit = DateBuilder.IntervalUnit.MINUTE;
        return this;
    }

    public CalendarIntervalScheduleBuilder withIntervalInHours(int intervalInHours) {
        this.validateInterval(intervalInHours);
        this.interval = intervalInHours;
        this.intervalUnit = DateBuilder.IntervalUnit.HOUR;
        return this;
    }

    public CalendarIntervalScheduleBuilder withIntervalInDays(int intervalInDays) {
        this.validateInterval(intervalInDays);
        this.interval = intervalInDays;
        this.intervalUnit = DateBuilder.IntervalUnit.DAY;
        return this;
    }

    public CalendarIntervalScheduleBuilder withIntervalInWeeks(int intervalInWeeks) {
        this.validateInterval(intervalInWeeks);
        this.interval = intervalInWeeks;
        this.intervalUnit = DateBuilder.IntervalUnit.WEEK;
        return this;
    }

    public CalendarIntervalScheduleBuilder withIntervalInMonths(int intervalInMonths) {
        this.validateInterval(intervalInMonths);
        this.interval = intervalInMonths;
        this.intervalUnit = DateBuilder.IntervalUnit.MONTH;
        return this;
    }

    public CalendarIntervalScheduleBuilder withIntervalInYears(int intervalInYears) {
        this.validateInterval(intervalInYears);
        this.interval = intervalInYears;
        this.intervalUnit = DateBuilder.IntervalUnit.YEAR;
        return this;
    }

    public CalendarIntervalScheduleBuilder withMisfireHandlingInstructionIgnoreMisfires() {
        this.misfireInstruction = -1;
        return this;
    }

    public CalendarIntervalScheduleBuilder withMisfireHandlingInstructionDoNothing() {
        this.misfireInstruction = 2;
        return this;
    }

    public CalendarIntervalScheduleBuilder withMisfireHandlingInstructionFireAndProceed() {
        this.misfireInstruction = 1;
        return this;
    }

    private void validateInterval(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("Interval must be a positive value.");
        }
    }
}

