/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.config;

import java.util.ArrayList;
import java.util.List;
import net.creeperhost.ftbbackups.config.Format;
import net.creeperhost.ftbbackups.config.RetentionMode;
import net.creeperhost.ftbbackups.repack.blue.endless.jankson.Comment;

public class ConfigData {
    @Comment(value="Allow the creation of backups automatically")
    public boolean enabled = true;
    @Comment(value="Permission level to use the /backup command")
    public int command_permission_level = 3;
    @Comment(value="Only send backup status to server ops")
    public boolean notify_op_only = true;
    @Comment(value="Don't send backup status at all")
    public boolean do_not_notify = false;
    @Comment(value="Backup retention mode. Valid Modes: MAX_BACKUPS, TIERED\nNote: TIERED mode is an experimental feature, Use at your own risk.")
    public RetentionMode retention_mode = RetentionMode.MAX_BACKUPS;
    @Comment(value="Applies to retention_mode:MAX_BACKUPS, Sets the maximum number of backups to keep")
    public int max_backups = 5;
    @Comment(value="Applies to retention_mode:TIERED, The latest x number of backups will be retained")
    public int keep_latest = 5;
    @Comment(value="Applies to retention_mode:TIERED, Sets number of hourly backups to keep")
    public int keep_hourly = 1;
    @Comment(value="Applies to retention_mode:TIERED, Sets number of daily backups to keep")
    public int keep_daily = 1;
    @Comment(value="Applies to retention_mode:TIERED, Sets number of weekly backups to keep")
    public int keep_weekly = 1;
    @Comment(value="Applies to retention_mode:TIERED, Sets number of monthly backups to keep")
    public int keep_monthly = 1;
    @Comment(value="This is done with an implementation of cron from the Quartz java library.\nMore info here\n(http://www.cronmaker.com)")
    public String backup_cron = "0 */30 * * * ?";
    @Comment(value="Time between manual backups using the command")
    public int manual_backups_time = 0;
    @Comment(value="Only run a backup if a player has been online since the last backup")
    public boolean only_if_players_been_online = true;
    @Deprecated(forRemoval=true)
    @Comment(value="Additional directories to include in backup")
    public List<String> additional_directories = new ArrayList<String>();
    @Comment(value="Additional files and directories to include in backup.\nCan specify a file name, path relative to server directory or wildcard file path\nExamples:                       (All file paths are relative to server root)\nfileName.txt                    Any/all file named \"fileName.txt\"\nfolder/file.txt                 Exact file path\nfolder/                         Everything in this folder\npath/starts/with*               Any files who's path starts with\n*path/ends/with.txt             Any files who's path ends with\n*path/contains*                 Any files who's path contains")
    public List<String> additional_files = new ArrayList<String>();
    @Comment(value="Display file size in backup message")
    public boolean display_file_size = false;
    @Comment(value="backup location")
    public String backup_location = ".";
    @Comment(value="Specify the backup format. Valid options are ZIP and DIRECTORY")
    public Format backup_format = Format.ZIP;
    @Comment(value="Minimum free disk space in MB. If a backup's creation would leave less than this amount of disk space remaining, the backup will be aborted.")
    public long minimum_free_space = 500L;
    @Comment(value="If the previous backup failed due to lack of space, the oldest backup will be deleted to free space.")
    public boolean free_space_if_needed = false;
    @Comment(value="Specify files or folders to be excluded.\nCan specify a file name, path relative to server directory or wildcard file path\nExamples:                       (All file paths are relative to server root)\nfileName.txt                    Any/all file named \"fileName.txt\"\nfolder/file.txt                 Exact file path\nfolder/                         Everything in this folder\npath/starts/with*               Any files who's path starts with\n*path/ends/with.txt             Any files who's path ends with\n*path/contains*                 Any files who's path contains")
    public List<String> excluded = new ArrayList<String>();
    @Comment(value="The dimension used when creating backup preview image, specify \"all\" to enable automatic detection of primary dimension (can be very slow)\nSpecify \"none\" to disable preview")
    public String preview_dimension = "minecraft:overworld";
}

