/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.atlasapi;

import com.mojang.logging.LogUtils;
import io.redspace.atlasapi.api.AtlasApiRegistry;
import io.redspace.atlasapi.internal.AtlasHandler;
import io.redspace.atlasapi.internal.DynamicModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.slf4j.Logger;

@Mod(value="atlas_api")
public class AtlasApi {
    public static final String MODID = "atlas_api";
    public static final Logger LOGGER = LogUtils.getLogger();

    public AtlasApi(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::registerModelLoader);
        modEventBus.addListener(this::registerClientListeners);
        modEventBus.addListener(this::registerRegistries);
        NeoForge.EVENT_BUS.addListener(this::onLogOut);
    }

    public void onLogOut(ClientPlayerNetworkEvent.LoggingOut event) {
        AtlasHandler.clear();
    }

    public void registerRegistries(NewRegistryEvent event) {
        event.register(AtlasApiRegistry.ASSET_HANDLER_REGISTRY);
    }

    public void registerClientListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new AtlasHandler());
    }

    public void registerModelLoader(ModelEvent.RegisterGeometryLoaders event) {
        event.register(AtlasApi.id("dynamic_model"), (IGeometryLoader)DynamicModel.Loader.INSTANCE);
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

