/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import java.util.stream.IntStream;
import net.minecraft.core.Direction;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import rearth.oritech.util.InventorySlotAssignment;

public class SimpleSidedInventory
extends SimpleContainer
implements WorldlyContainer {
    public final InventorySlotAssignment slotAssignment;

    public SimpleSidedInventory(int size, InventorySlotAssignment slotAssignment) {
        super(size);
        this.slotAssignment = slotAssignment;
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return this.slotAssignment.isOutput(slot);
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return this.slotAssignment.isInput(slot);
    }

    public int[] getSlotsForFace(Direction side) {
        switch (side) {
            case UP: {
                return IntStream.range(this.slotAssignment.inputStart(), this.slotAssignment.inputStart() + this.slotAssignment.inputCount()).toArray();
            }
            case DOWN: {
                return IntStream.range(this.slotAssignment.outputStart(), this.slotAssignment.outputStart() + this.slotAssignment.outputCount()).toArray();
            }
        }
        return IntStream.concat(IntStream.range(this.slotAssignment.inputStart(), this.slotAssignment.inputStart() + this.slotAssignment.inputCount()), IntStream.range(this.slotAssignment.outputStart(), this.slotAssignment.outputStart() + this.slotAssignment.outputCount())).toArray();
    }
}

